﻿// <copyright file="ContainerModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ContainerModel
* Base class for model os container controls (like window and panels)
*/
define(['base/ControlModel'], function (ControlModel) {

    var CHILDREN_ADDED_EVENT = 'children added';

    return ControlModel.extend({

        initModel: function (model, context) {
            this._super(model, undefined);
            if (model && model.childModels) {
                this.childModels = model.childModels;
                this.fireOnChildrenAdded(model.childModels, context);
            }
        },

        subscribeOnChildrenAdded: function (handler, context) {
            this.eventTarget.addListener(CHILDREN_ADDED_EVENT, handler, context);
        },

        unsubscribeOnChildrenAdded: function (handler) {
            this.eventTarget.removeListener(CHILDREN_ADDED_EVENT, handler);
        },

        fireOnChildrenAdded: function (childModels, context) {
            this.eventTarget.fire({
                type: CHILDREN_ADDED_EVENT,
                target: this,
                childModels: childModels,
                context: context
            });
        }
    });
});