﻿// <copyright file="MessageIndicator.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ControlModel'],
function (Enums, ControlModel) {
    
    var MessageIndicator = ControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'MessageIndicator';
        },

        getOptionsForEM: function () {
            var program = this.get(Enums.ParameterRoles.OBJECT_UID);
            return {
                requestedPublishingInterval: this.get(Enums.ParameterRoles.UPDATE_PERIOD),
                taskId: program.taskNumber,
                itemId: program.itemId,
                path: ''
            };
        },

        getFiltersForEM: function () {
            var filters = [];
            _.forEach(this.getFilters(), function (filter) {
                if (filter.value[Enums.ParameterRoles.ENABLED].value === true) {
                    filters.push(filter.value[Enums.ParameterRoles.CONDITION].value);
                }
            });

            return filters;
        },

        getColumnsForEM: function() {
            return [
                {
                    id: 0,
                    name: 'EventId',
                    type: 'STRING',
                    typeHash: 0
                }
            ];
        },
        getFilters: function () {
            return this.get(Enums.ParameterRoles.FILTERS);
        },

        getFiltersProperty: function () {
            return this.getProperty(Enums.ParameterRoles.FILTERS);
        },

        getDataSource: function () {
            return this.get(Enums.ParameterRoles.DATA_SOURCE);
        },

        getObjectUIDProperty: function () {
            return this.getProperty(Enums.ParameterRoles.OBJECT_UID);
        }

    });

    return MessageIndicator;
});
