﻿define(['controls/Types', 'common/Enums'], function (Types, Enums) {

    var ParametersFactory = Class.extend({

        init: function () {
        },

        getType: function (typeName) {
            var type = Types[typeName];
            if (type === undefined) {
                console.error(String.format('Unknown type {0}', typeName));           
            }

            return type;
        },

        createByType: function (typeName) {
            var type = Types[typeName];
            if (type === undefined) {
                console.error(String.format('Unknown type {0}', typeName));
                return {
                    typeName: undefined,
                    typeHash: -1,
                    value: undefined
                };
            }

            switch (type.type) {
                case Enums.type.object:
                    return this._createObjectParam(typeName);
                case Enums.type.array:
                    return this._createArrayParam(typeName);
                default:
                    return this._createElementaryParam(typeName);
            }
        },       

        _createObjectParam: function (typeName) {
            var type = Types[typeName];
            var objectParam = {
                typeName: typeName,
                typeHash: type.typeHash,                
                value: {}
            };
            var ctx = this;
            //по каждому имени свойства
            _.forOwn(type.description, function (descType, descName) {                
                objectParam.value[descName] = ctx.createByType(descType);
            });

            return objectParam;
        },
        
        _createArrayParam: function (typeName) {
            var type = Types[typeName],
                dimensions = type.description.dimensions;
            return {
                typeName: typeName,
                typeHash: type.typeHash,
                value: this._createDimension(type.description.arrayItemType, type, typeName, 0, dimensions)
            };
        },

        //arrayItemType - имя элемента массива
        //arrType, arrTypeName - тип и имя самого объекта массива
        _createDimension: function (arrItemTypeName, arrType, arrTypeName, curr, dimensions) {

            var dimension = dimensions[curr], //[startIndex, length]              
                startIndex = 0, //пока наполняем без учета старта dimensions[0],
                length = dimension[1],
                arr = [],
                nextRange = curr + 1,
                i,
                subTypeName;
            //в fb  range.End - range.Begin + 1
            for (i = startIndex; i < length; i++) {
                //если самая глубокая ось (т.е последняя)
                 if (curr === dimensions.length - 1) {
                     arr.push(this.createByType(arrItemTypeName));
                 } else {
                     //т.к для вложенных массивов нету имени типа, пишем свой
                     subTypeName = String.format('{0}[{1}]', arrTypeName, curr);
                     arr.push({
                         typeName: subTypeName,
                         typeHash: arrType.typeHash,
                         value: this._createDimension(arrItemTypeName, arrType, subTypeName, nextRange, dimensions)
                     });
                 }
            }

            return arr;
        },

        _createElementaryParam: function (typeName) {
            var type = Types[typeName];
            return {
                typeName: typeName,
                typeHash: type.typeHash,             
                value: undefined
            }
        }
    });

    var instance = new ParametersFactory();

    return instance;
}
);