﻿// <copyright file="TaskBarModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// _completedRequest

/*
* @class TaskBarModel model class for TabControl control
*/
define(['common/Enums', 'controls/StackPanel/StackPanelModel'],
function (Enums, StackPanelModel) {

    var TaskBarModel = StackPanelModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'TaskBarModel';
        },

        getOrientation: function () {
            switch (this.getAnchor()) {
                case Enums.AnchorType.Up:
                case Enums.AnchorType.Down:
                    return Enums.OrientationType.Horizontal;
                case Enums.AnchorType.Left:
                case Enums.AnchorType.Right:
                    return Enums.OrientationType.Vertical
                default:
                    return Enums.OrientationType.Horizontal;
            }
        },

        getVerticalElementsAlign: function () {
            switch (this.getAnchor()) {
                case Enums.AnchorType.Up:
                case Enums.AnchorType.Down:
                    return Enums.VerticalElementsAlign.Stretch;
                case Enums.AnchorType.Left:
                case Enums.AnchorType.Right:
                    // use anything that differs from Stretch here to avoid changes in child control heights.
                    return Enums.VerticalElementsAlign.Top;
                default:
                    return Enums.VerticalElementsAlign.Stretch;
            }
        },

        getHorizontalElementsAlign: function () {
            switch (this.getAnchor()) {
                case Enums.AnchorType.Up:
                case Enums.AnchorType.Down:
                    // use anything that differs from Stretch here to avoid changes in child control widths.
                    return Enums.HorizontalElementsAlign.Left;
                case Enums.AnchorType.Left:
                case Enums.AnchorType.Right:
                    return Enums.HorizontalElementsAlign.Stretch;
                default:
                    // use anything that differs from Stretch here to avoid changes in child control widths.
                    return Enums.HorizontalElementsAlign.Left;
            }
        },

        getX: function() {
            switch (this.getAnchor()) {
                case Enums.AnchorType.Up:
                case Enums.AnchorType.Down:
                    return 0;
                case Enums.AnchorType.Left:
                    return this.getWidth();
                case Enums.AnchorType.Right:
                    return -this.getWidth();
                default:
                    return 0;
            }
        },

        getY: function () {
            switch (this.getAnchor()) {
                case Enums.AnchorType.Up:
                case Enums.AnchorType.Left:
                case Enums.AnchorType.Right:
                    return 0;
                case Enums.AnchorType.Down:
                    return this.getHeight();
                default:
                    return 0;
            }
        },

        getAnchor: function () {
            return this.get(Enums.ParameterRoles.ANCHOR);
        },

        getAutoPopUp: function () {
            //если вдруг не будет AutoPopup - уйдем в бесконечную рекурсию ошибок            
            if (this._data[Enums.ParameterRoles.AUTO_POPUP]) {
                return this.get(Enums.ParameterRoles.AUTO_POPUP);
            }

            return false;
        }
    });

    return TaskBarModel;
});