﻿// <copyright file="OpenWindowAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/OpenWindowActionBase', 'common/Appearence',
    'common/Enums', 'core/L10n',
    'core/global/GlobalSettings', 'common/Utilites', 'helpers/contextResolver'],
    function (OpenWindowActionBase, Appearence, Enums, L10n, GlobalSettings, Utilites, contextResolver) {
        return OpenWindowActionBase.extend({
            init: function (options) {
                this._super(options);

                this._onResizeBind = this._onResize.bind(this);
            },

            executeInternal: function (context, resolve, reject, notify) {

                if (this.dialogContainer) {
                    return;
                }
                this.askConfirmation(context, resolve, this);
            },

            allowAct: function (args) {
                var resolve = args.resolve;
                var that = args.that;
                var dialogContainer = that.dialogContainer;
                that._bindProperties();

                var options = that.getOptions(dialogContainer.view.$(), resolve);
                var dlg = dialogContainer.view.$().dialog(options);
                var collapse = that.getCollapseButton();
                if (that.get(Enums.ParameterRoles.CAN_MINIMIZE)) {
                    collapse.style.display = 'block';
                }
                else {
                    collapse.style.display = 'none';
                }

                if (that.get(Enums.ParameterRoles.CAN_CLOSE) === false) {
                    that.getCloseButton().style.display = 'none';
                }
                //#10818
                if (Utilites.isWebkit()) {
                    var handles = dlg.parent().children('.ui-resizable-handle');
                    handles.hide().width();
                    handles.show();
                    handles = null;
                    dlg = null;
                }
                dialogContainer.controller.getNestedWindow().controller.onAddedToParent();
                if (that.get(Enums.ParameterRoles.SIZE_TO_CONTENT) === Enums.SizeToContentType.SetSize) {
                    that.dialogContainer.controller.setControlHeight(dialogContainer.model.get(Enums.ParameterRoles.HEIGHT));
                    that.dialogContainer.controller.setControlWidth(dialogContainer.model.get(Enums.ParameterRoles.WIDTH));
                }
                dialogContainer.controller.mvc.view.$().parent().css('width', dialogContainer.controller.mvc.model.get(Enums.ParameterRoles.WIDTH));
                var point = that.getOpenPosition(args.context)
                that._onPositionChanged(point);
            },

            denyAct: function (args) {
                var that = args.that;
                that.dialogContainer = null;
            },

            getCollapseButton: function () {
                return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-collapse")[0];
            },

            getCloseButton: function () {
                return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-close")[0];
            },

            getCollapseRestoreButton: function () {
                return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-collapse-restore")[0];
            },

            getWindow: function () {
                return this.dialogContainer.controller.getNestedWindow();
            },

            _onModelPropertyChanged: function (event) {
                this._super(event);

                switch (event.property) {
                    case Enums.ParameterRoles.TEXT:
                        if (this.getWindow() !== null && this.dialogContainer !== null) {
                            this.dialogContainer.view.$().dialog('option', 'title', event.newValue.value);
                        }
                        break;
                    case Enums.ParameterRoles.WIDTH:
                        if (this.getWindow()) {
                            this.dialogContainer.view.$().dialog("widget").css({
                                minWidth: this.get(Enums.ParameterRoles.WIDTH),
                                width: this.get(Enums.ParameterRoles.WIDTH)
                            });
                            this.getWindow().controller.onWidthChanged();
                        }
                        break;
                    case Enums.ParameterRoles.HEIGHT:
                        if (this.getWindow()) {
                            var titleHeight = GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_HEIGHT);
                            this.dialogContainer.view.$().css({
                                height: this.get(Enums.ParameterRoles.HEIGHT) + titleHeight
                            });

                            this.getWindow().controller.onHeightChanged();
                        }
                        break;
                    case Enums.ParameterRoles.X:
                    case Enums.ParameterRoles.Y:
                        if (this.getWindow()) {
                            var x = this.get(Enums.ParameterRoles.X);
                            var y = this.get(Enums.ParameterRoles.Y);
                            var ctx = this.dialogContainer.controller.mvc._parent.controller;
                            var deltaActualOffset = this.getActualOffset(x, y, ctx);
                            var point = {
                                x: deltaActualOffset.x + this.openPosition.x,
                                y: deltaActualOffset.y + this.openPosition.y
                            };
                            this._onPositionChanged(point);
                        }
                        break;
                    case Enums.ParameterRoles.DIALOG_HEADER_TEXT_COLOR:
                        if (this.getWindow() !== null && this.dialogContainer !== null) {
                            this.dialogContainer.view.$().dialog('option', 'titleTextColor', event.newValue.value);
                        }
                        break;
                    case Enums.ParameterRoles.HEADER_BACKGROUND_COLOR:
                        if (this.getWindow() !== null && this.dialogContainer !== null) {
                            this.dialogContainer.view.$().dialog('option', 'backgroundColor',
                                Appearence.color.toCssColor(event.newValue.value));
                        }
                        break;
                    case Enums.ParameterRoles.SIZE_TO_CONTENT:
                        this.dialogContainer.model.set(Enums.ParameterRoles.SIZE_TO_CONTENT, event.newValue.value);
                        this.dialogContainer.controller.initFrame(this.dialogContainer);
                        break;
                    case Enums.ParameterRoles.CAN_MINIMIZE:
                        var collapse = this.getCollapseButton();
                        var collapse_restore = this.getCollapseRestoreButton();
                        if (event.newValue.value) {
                            if (this.isCollapsed()) {      //если окно скрыто
                                collapse_restore.style.display = 'block';//то восстанавливать нужно рестор
                            }
                            else {
                                collapse.style.display = 'block';
                            }
                        } else {
                            collapse_restore.style.display = 'none';
                            collapse.style.display = 'none';
                        }
                        break;
                    case Enums.ParameterRoles.CAN_RESIZE:
                        this.dialogContainer.view.$().dialog('option', 'resizable', event.newValue.value);
                        break;
                    case Enums.ParameterRoles.CAN_CLOSE:
                        if (this.get(Enums.ParameterRoles.CAN_CLOSE) === false) {
                            this.getCloseButton().style.display = 'none';
                        } else {
                            this.getCloseButton().style.display = 'block';
                        }
                }
            },

            isCollapsed: function () {
                return this.dialogContainer.view.$().css('height') == '0px';
            },

            _onPositionChanged: function (point) {
                this.dialogContainer.view.$().dialog("widget").css({
                    left: point.x,
                    top: point.y
                });
            },

            getOpenPosition: function (ctx) {
                var x = this.replacedModelParameters.X;
                var y = this.replacedModelParameters.Y;

                x = x ? x.value : 0;
                y = y ? y.value : 0;

                if (this.isPropertyExists(Enums.ParameterRoles.X))
                    x = this.get(Enums.ParameterRoles.X);
                if (this.isPropertyExists(Enums.ParameterRoles.Y))
                    y = this.get(Enums.ParameterRoles.Y);

                var actualOffset = this.getActualOffset(x, y, ctx);

                switch (this.get(Enums.ParameterRoles.OPEN_DIALOG_POINT)) {
                    case Enums.OpenDialogPoint.ElementOffset: //смещение от элемента
                        var totalOffset = this.getTotalOffset(ctx);
                        var point = {
                            x: totalOffset.currentLeft + ctx.getControlWidthPx(),
                            y: totalOffset.currentTop
                        };
                        this.openPosition = point;
                        return point = {
                            x: point.x + actualOffset.x,
                            y: point.y + actualOffset.y
                        };
                    case Enums.OpenDialogPoint.PointerOffset: //смещение от указателя
                        var pointerX, pointerY;
                        for (key in ctx.events) {
                            pointerX = ctx.events[key]._data.X.value;
                            pointerY = ctx.events[key]._data.Y.value;
                        }
                        var point = {
                            x: pointerX,
                            y: pointerY
                        };
                        this.openPosition = point;
                        return point = {
                            x: point.x + actualOffset.x,
                            y: point.y + actualOffset.y
                        };
                    case Enums.OpenDialogPoint.WindowOffset: //смещение от окна (по заданным)  
                        this.openPosition = { x: 0, y: 0 };
                        return point = {
                            x: actualOffset.x,
                            y: actualOffset.y
                        };
                    default: //в центре по умолчанию
                        var rootWindow = contextResolver.getRootWindow(ctx);
                        rootWindow = rootWindow.controller ? rootWindow.controller : ctx;
                        var point = {
                            x: rootWindow.getControlWidthPx() / 2,
                            y: rootWindow.getControlHeightPx() / 2
                        };
                        this.openPosition = point;
                        return point;
                }
            },

            getTotalOffset: function (context) {
                var parent = context.mvc._parent;
                var sizes = {
                    currentLeft: context.getControlLeftPx(),
                    currentTop: context.getControlTopPx()
                }
                var rootWindow = contextResolver.getRootWindow(context);

                while (parent != rootWindow) {
                    context = parent;
                    sizes.currentLeft = sizes.currentLeft + context.controller.getControlLeftPx();
                    sizes.currentTop = sizes.currentTop + context.controller.getControlTopPx();
                    parent = context._parent;
                }
                return sizes;
            },

            getActualOffset: function (x, y, ctx) {
                var rootWindow = contextResolver.getRootWindow(ctx);
                var actualOffsetX;
                var actualOffsetY
                if (!rootWindow.controller) {
                    rootWindow = ctx;
                    actualOffsetX = x / rootWindow.mvc.model.getWidth() * rootWindow.mvc.controller.getControlWidthPx();
                    actualOffsetY = y / rootWindow.mvc.model.getHeight() * rootWindow.mvc.controller.getControlHeightPx();
                } else {
                    actualOffsetX = x / rootWindow.model.getWidth() * rootWindow.controller.getControlWidthPx();
                    actualOffsetY = y / rootWindow.model.getHeight() * rootWindow.controller.getControlHeightPx();
                }
                return point = {
                    x: actualOffsetX,
                    y: actualOffsetY
                }
            },

            _onResize: function (width, height) {
                if (this.get(Enums.ParameterRoles.SIZE_TO_CONTENT) === Enums.SizeToContentType.SetSize) {
                    this.dialogContainer.controller.setControlHeight(height);
                    this.dialogContainer.controller.setControlWidth(width);
                }
                this.dialogContainer.controller.getNestedWindow().controller.onParentActualWidthChanged();
                this.dialogContainer.controller.getNestedWindow().controller.onParentActualHeightChanged();
            },

            getOptions: function (dialogContainer, resolve) {
                var backgroundColor = Appearence.color.toCssColor(this.get(Enums.ParameterRoles.HEADER_BACKGROUND_COLOR));
                var that = this;
                var options = {
                    resizable: this.get(Enums.ParameterRoles.CAN_RESIZE),
                    collapseEnabled: true,
                    title: this.get(Enums.ParameterRoles.TEXT),
                    backgroundColor: backgroundColor,
                    titleTextColor: this.get(Enums.ParameterRoles.DIALOG_HEADER_TEXT_COLOR),
                    headerHeight: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_HEIGHT),
                    headerFontSize: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_FONT_SIZE),
                    headerFontName: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_FONT_NAME),
                    width: this.dialogContainer.model.get(Enums.ParameterRoles.WIDTH),
                    height: this.dialogContainer.model.get(Enums.ParameterRoles.HEIGHT),
                    setWidth: true,
                    containment: 'parent',
                    closeText: L10n.get('messages.dialogClose'),
                    collapseText: L10n.get('messages.dialogCollapse'),
                    restoreText: L10n.get('messages.dialogRestore'),
                    close: function (event, ui) {
                        event.stopPropagation();
                        event.preventDefault();
                        that._retrieveOutputPrams();
                        that.unsubscribePropertyChanged(that._onModelPropertyChanged);
                        that.getWindow().model.unsubscribePropertyChanged(that._onWindowPropertyChanged);
                        that.dialogContainer.controller.removeChildControl(that.dialogContainer.controller.frameWindow);
                        that.dialogContainer.destroy();
                        that.dialogContainer = null;
                        $(this).remove();
                        resolve();
                    },

                    resize: function (event, ui) {
                        that._onResizeBind(event.target.offsetWidth, event.target.offsetHeight);
                    }
                };

                return options;
            },

            destroy: function () {
                if (this.dialogContainer) {
                    this.dialogContainer.controller.removeChildControl(this.dialogContainer.controller.frameWindow);
                    this.dialogContainer.view.$().dialog('destroy').remove();
                    this.dialogContainer.view.$().remove();
                }
            }
        });
    });
