// <copyright file="ConditionAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['helpers/contextResolver', 'core/adapters/BaseAdapter'], function (contextResolver, BaseAdapter) {

    var ConditionAdapter = BaseAdapter.extend({
        init: function (settings, type) {
            this._super(settings, type);
            var arr = settings.path.split("/");
            if (arr.length === 3) { // elementId/tgiggerId/conditionId
                this.elementPath = arr[0];
                this.triggerId = arr[1];
                this.conditionId = arr[2];               
            } else {
                this.elementPath = "/";
                this.triggerId = arr[0];
                this.conditionId = arr[1];
            }
            
            //       Condtiton
            this.propertyPath = settings.propertyPath.replace("_Parametr_usloviya", "operand").replace("_Znachenie_usloviya", "compareWith");
            this.adapterType = "ConditionAdapter";
        },

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.elementPath, ctx).controller.triggerHandler.triggersDictionary[this.triggerId].conditionsDictionary[this.conditionId];
        }
    });

    return ConditionAdapter;	   	
});