// <copyright file="MasterPLCAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['helpers/contextResolver', 'core/adapters/BaseAdapter'], function (contextResolver, BaseAdapter) {

    var MasterPLCAdapter = BaseAdapter.extend({
        init: function (settings, type) {
            this._super(settings, type);

            this.itemId = settings.itemId;              
            this.path = settings.path;
            this.propertyPath = settings.propertyPath;

            this.adapterType = "MasterPLCAdapter";
            this.dataSource = "MPLCDataSource";
        },

        get: function (sender) {
            return this.getDataSource(sender).getProperty(this.resolveItemId(sender), this.propertyPath);
        },

        getType: function (sender) {
            return this.getDataSource(sender).getPropertyType(this.resolveItemId(sender), this.propertyPath);
        },

        set: function (sender, newValue, operation) {
            this.getDataSource(sender).setProperty(this.resolveItemId(sender), this.propertyPath, newValue, operation);
        },

        resolveItemId: function (sender) {
            if (this.itemId != 0)
                return this.itemId;
            if (sender.model !== undefined && sender.model.objectId !== undefined)
                return sender.model.objectId;
            return 0;
        },

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.path, ctx).controller.getVariablesSource(this.dataSource);
        }
    });	

    return MasterPLCAdapter;
});