﻿
var Enums = {
    access: {
        local: 'local',
        input: 'input',
        output: 'output'
    },

    pathPartType: {
        index: 'index',
        name: 'name'
    }
};

var propertyPathSeparator = '.',
     namePartReg = /(\[\d+\]){1}/i,
     arrIndexReg = /\[(\d+)\]/;

function forOwn(obj, callback) {
    for (var propName in obj) {
        if (obj.hasOwnProperty(propName)) {
            callback(obj[propName], propName);
        }
    }
}
function getLeadEdge(cu, leCu) {
    if ((leCu.value == false) && (cu == true)) {
        leCu.value = true;
        return true;
    }
    /*if (cu == false) {
        leCu.value = false;
    }*/
        return false;
}

function getBackEdge(cu, leCu) {
    if ((leCu.value == true) && (cu == false)) {
        leCu.value = false;
        return true;
    }
    /*if (cu == true) {
        leCu.value = true;
    }*/
        return false;
}
function forEach(collection, callback) {
    var i;
    for (i = 0; i < collection.length; i++) {
        callback(collection[i]);
    }
}

function compact(array) {
    var index = -1,
        length = array ? array.length : 0,
        result = [];

    while (++index < length) {
        var value = array[index];
        if (value) {
            result.push(value);
        }
    }
    return result;
}

function pcall() {
    try {
        var funcResult = arguments[0].apply({}, Array.prototype.slice.call(arguments, 1));
        funcResult = funcResult instanceof Array ? funcResult : [funcResult];
        return [true].concat(funcResult);
    }
    catch (ex) {
        console.error(ex.message || ex);
        console.error(ex.stack);
        return [false];
    }
}

function fbcall(fb) {
    try {
        fb._call();
        return true;
    }
    catch (ex) {
        console.error(ex.message || ex);
        console.error(ex.stack);
        return false;
    }
}

function invokeFunctionBlock(parameters) {

}
function getProp(name) {
    return this.global[name];
}
function setFBParams(params) {
    //params {path: value}
    forOwn(params, function (value, path) {
        if (path === 'global') {
            self.global = params.global;
            return;
        }

        var prop = self.inputParams[path];
        if (prop === undefined) {
            console.error('Unknown parameter path:' + path);
            return;
        }
        prop.property[prop.key] = value;
    });
}
function send(obj) {
    postMessage(obj);
}

function callAction(action) {
    postMessage(action);
}

function getFBParam(path) {
    var pathParts = path.split(propertyPathSeparator),
        currentObject = self.GLOBAL,
        i;

    for (i = 0; i < pathParts.length - 1; i++) {
        var pathPart = pathParts[i];
        var nameParts = compact(pathPart.split(namePartReg));
        var j;
        for (j = 0; j < nameParts.length; j++) {
            var namePart = getPathPart(nameParts[j]);
            currentObject = currentObject[namePart];
        }
    };

    return {
        prop: currentObject,
        key: getPathPart(pathParts[pathParts.length - 1])
    }
}

function getPathPart(namePart) {
    var arrIndex = namePart.match(arrIndexReg);
    if (arrIndex != null) {
        return arrIndex[1];
    } else {
        return namePart
    }
}

function bindParams(params) {
    forOwn(params, function (prop, paramPath) {
        var fbProp = getFBParam(paramPath);
        prop.property = fbProp.prop;
        prop.key = fbProp.key;
    });
}

function getOutValues() {
    var data = {};
    forOwn(self.outputParams, function (prop, paramPath) {
        data[paramPath] = prop.property[prop.key];
    });

    return data;
}