﻿// <copyright file="ControlController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class BooleanControlController
* Base class for controllers of controls like RadioButton and Checkbox
*/

define(['common/Enums', 'common/Appearence', 'base/ControlController'],
function (Enums, Appearence, ControlController) {

    var BooleanControlController = ControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'BooleanControlController';
        },

        onSvgIsCheckedChanged: function (value) {
            this.onCustomParameterChanged("off:display:style", Appearence.getDisplay(!value));
            this.onCustomParameterChanged("on:display:style", Appearence.getDisplay(value));
        }
    });
    return BooleanControlController;
});
