﻿// <copyright file="Model.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class Model
* Base class for models
*/
define(['common/Enums', 'base/ObservableObject', 'common/Utilites', 'common/Error'],
    function (Enums, ObservableObject, Utilites, Error) {

        var namePartReg = /(\[\d+\]){1}/i,
            arrIndexReg = /\[(\d+)\]/;

        var Model = ObservableObject.extend({
            propertyPathSeparator: '.',           

            init: function () {                
                this._super();
                this.ClassName = 'Model';
                this._data = {};
            },


            setProperty: function (name, newProperty, silent, force) {
                try {
                    var oldProperty = this._getProperty(name, false);
                    var changingEvent;                
                    //копия нужна, т.к связь может писать в несколько моделей
                    var newProp = $.extend(true, {}, newProperty);

                    if (newProp.value === undefined) {
                        this._onValueMissing('Possible error: property name:' + name + ' object:' + Utilites.stringifyObj(newProp) + ' value: ' + Utilites.stringifyObj(newProp.value));
                    }             

                    //TODO change to equal compare
                    if (force || oldProperty == undefined || !Utilites.compareValues(newProp.value, oldProperty.value)) {

                        changingEvent = {
                            oldProperty: $.extend(true, {}, oldProperty),
                            newProperty: newProp,
                            cancel: false,
                            silent: false
                        };

                        this.firePropertyChanging(name, changingEvent);

                        if (changingEvent.cancel) {
                            return;
                        }

                        if (oldProperty == undefined) {
                            this._onValueMissing('Possible error: set not-initialized property: ' + name);
                            this._data[name] = newProp;
                        } else {                    
                            oldProperty.value = newProp.value;
                            this._appendAttributes(newProp, oldProperty);
                        }

                        if (silent || changingEvent.silent) {
                            return this; // do not fire events
                        }

                        this.firePropertyChanged(name, changingEvent.oldProperty, newProp);
                    }
                }
                catch (e) {
                    Error.onerror('Error setting property');
                }
            },

            _onValueMissing: function (msg) {
                Error.debug(msg);
            },

            // Setter
            set: function (name, value, silent, force) {
                var property = this._getProperty(name, false);
                if (property === undefined) {
                    Error.debug(String.format('Property {0} is not exist', name));
                    return;
                }

                this.setProperty(name, { typeName: property.typeName, value: value, }, silent, force);
            },

            getProperty: function (arg) {
                return this._getProperty(arg, true);
            },

            getPropertyType: function (arg) {
                var property = this._getProperty(arg, false);
                if (property === undefined) {
                    Error.debug('Possible error: cannot get type of undefinied: ' + arg);
                    return undefined;
                }

                return property.typeName;
            },

            _getProperty: function (arg, isCopy, shouldExists) {
                // Full model getter
                if (arg === undefined) {
                    return this._data;
                }

                // Attribute getter
                if (typeof arg === 'string') {
                    var property = this._getPropertyByPath(arg);

                    if (property === undefined &&
                        (shouldExists === undefined || shouldExists === true)) {
                        Error.debug('Possible error: requested undefinied: ' + arg);
                        return undefined;
                    }

                    if (isCopy && property !== undefined) {
                        return $.extend(true, {}, property);
                    }

                    return property;
                }

                Error.onerror('Unknown argument for getter.');
            },

            // Getter
            get: function (arg) {
                var property = this._getProperty(arg, false);
                if (property === undefined) {
                    Error.debug(String.format('Property {0} at class {1} does not exist', arg, this.ClassName));
                    return undefined;
                }
                if (property === null)
                    return null;

                return property.value;
            },

            getAll: function () {
                return this._data;
            },

            _getPropertyByPath: function (path) {

                if (path === '') {
                    Error.debug('Requested empty name');
                    return this._data;
                }

                var pathParts = path.split(this.propertyPathSeparator),
                    currentProperty = { value: this._data },
                    nameParts,
                    arrIndex,
                    i,
                    j,
                    l,
                    k;

                if (path.indexOf('.') < 0 && path.indexOf('[') < 0) {
                    return this._getPropertyByName(currentProperty, path);
                }

                for (i = 0, l = pathParts.length; i < l; ++i) {
                    nameParts = _.compact(pathParts[i].split(namePartReg));//Pen, [0]
                    for(j = 0, k = nameParts.length; j < k; ++j) {
                        //проверяем, что это индекс  + сразу вытягиваем его без скобок []
                        arrIndex = nameParts[j].match(arrIndexReg);
                        if (arrIndex != null) {
                            currentProperty = this._getPropertyByArrayIndex(currentProperty, arrIndex[1]);
                        } else {
                            currentProperty = this._getPropertyByName(currentProperty, nameParts[j]);
                        }
                    }
                }

                return currentProperty;
            },

            _getPropertyByName: function (currentProperty, namePart) {
                if (currentProperty.value) {
                    return currentProperty.value[namePart];
                } else {
                    return currentProperty[namePart]; //на тот случай если имеем дело со структурой
                }
            },

            _getPropertyByArrayIndex: function (currentProperty, index) {
                return currentProperty.value[index];
            },

            _appendAttributes: function (newProperty, oldProperty) {
                if (newProperty.hasOwnProperty(Enums.ServerVariablesProperties.statusCode)) {
                    oldProperty[Enums.ServerVariablesProperties.statusCode] = newProperty[Enums.ServerVariablesProperties.statusCode];
                }
                if (newProperty.hasOwnProperty(Enums.ServerVariablesProperties.sourceTime)) {
                    oldProperty[Enums.ServerVariablesProperties.sourceTime] = newProperty[Enums.ServerVariablesProperties.sourceTime];
                }
            },

            isPropertyExists: function (arg) {
                var property = this._getProperty(arg, false, false);
                return property !== undefined;
            },

            //Alex: to let know agility to not make proxy for models
            _noProxy: function () { },
        });


        return Model;
    });
