define(['common/ParameterRoles', 'controls/Types'], function (parameterRoles, Types) {

    var enums = {
        //Begin editor enums
        SizeType: {
            Relative: 'Relative',
            Pixel: 'Pixel',
            INCHES: 'Inch', //deprecated
            POINTS: 'Point' //deprecated
        },

        DockType: {
            Up: 'Up',
            Down: 'Down',
            Right: 'Right',
            Left: 'Left'
        },

        AnchorType: {
            Up: 'Up',
            Down: 'Down',
            Right: 'Right',
            Left: 'Left',
            None: 'None'
        },

        TileType: {
            No: 'No',
            Tile: 'Tile',
            Fill: 'Fill',
            Center: 'Center'
        },      

        ProportionType: {
            No: 'No',
            Width: 'Width',
            Height: 'Height',
            Min: 'Min',
            Max: 'Max'
        },

        KeyboardType: {
            INTERNATIONAL: 'International',
            English: 'English',
            Russian: 'Russian',
            NumPad: 'NumPad',
            HEX: 'Hex'
        },

        KeyboardVisibilityType: {
            None: 'None',
            Always: 'Always',
            OnFocus: 'OnFocus'
        },

        KeyboardPosition: {
            UP: 'Up',
            DOWN: 'Down',
            LEFT: 'Left',
            RIGHT: 'Right'
        },

        AttachType: {
            Control: 'Control',
            Parent: 'Parent'
        },      

        DateTimeType: {
            Date_Type: 'Date_Type',
            DateTime_Type: 'DateTime_Type',
            Time_Type: 'Time_Type',
            TimeDate_Type: 'TimeDate_Type'
        },

        SizeToContentType: {
            RealSize: 'RealSize',
            SetSize: 'SetSize',
            Crop: 'Crop',
            Scroll: 'Scroll'
        },

        FillDirection: {
            Up: 'Up',
            Down: 'Down'
        },

        LayoutType: {
            Up: 'Up',
            Down: 'Down',
            Left: 'Left',
            Right: 'Right'
        },

        LineJoin: {
            Line: 'Line',
            StairsUp: 'StairsUp',
            StairsDown: 'StairsDown'
        },

        SortType: {
            none: 'none', //deprecated
            Asc: 'Asc',
            Desc: 'Desc',
            No: 'No'
        },

        HorizontalElementsAlign: {
            Left: 'Left',
            Right: 'Right',
            Center: 'Center',
            Stretch: 'Stretch'
        },

        VerticalElementsAlign: {
            Top: 'Top',
            Bottom: 'Bottom',
            Center: 'Center',
            Stretch: 'Stretch'
        },

        TextHorizontalAlignment: {
            Left: 'Left',
            Right: 'Right',
            Center: 'Center',
            Justyfy: 'Justyfy',
            Auto: 'Auto',
            Inherit: 'Inherit'
        },

        TextVerticalAlignment: {
            Baseline: 'Baseline',
            Bottom: 'Bottom',
            MIDDLE: 'Center',
            Sub: 'Sub',
            Super: 'Super',
            Bottom: 'Bottom',
            TextTop: 'TextTop',
            Top: 'Top',
            Inherit: 'Inherit'
        },


        //End editor enums

        FullScreenMode: {
            scheme: 'Scheme',
            browser: 'Browser'
        },

        updateType: {
            timer: 'timer',
            onchange: 'onchange'
        },

        connectionType: {
            client: 'client',
            server: 'server',
            action: 'action',
            static: 'static',
            condition: 'condition',
            svg: 'svg',
            event: 'event',
            functionBlock: 'functionblock',
            protocolTask: 'protocoltask'
        },

        operation: {
            move: 'move',
            add: 'add',
            subtract: 'subtract',
            multiply: 'multiply',
            divide: 'divide',
            concat: 'concat'
        },     
               

        LinearGradientBrushDirection: {
            TOP: 'topgradient',
            LEFT: 'leftgradient',
            BOTTOM: 'bottomgradient',
            RIGHT: 'rightgradient',
            TOP_LEFT: 'topleftgradient',
            TOP_RIGHT: 'toprightgradient',
            BOTTOM_LEFT: 'bottomleftgradient',
            BOTTOM_RIGHT: 'bottomrightgradient',
        },       

        BrushType: {
            NONE: 'None',
            SOLID: 'Solid',
            LINEAR_GRADIENT: 'lineargradient',
            RADIAL_GRADIENT: 'radialgradient'
        },

        BorderStyleType: {
            Solid: 'Solid',
            Dot: 'Dot',
            Dash: 'Dash',
            None: 'None'
        },

        PenAlignment: {
            INSET: 'inset',
            OUTSET: 'outset'
        },      

        parameterType: {
            boolean: "boolean",
            borderStyle: "BorderStyle",
            coord: "coord",
            color: "color",
            date: "date",
            linearGradientBrush: "LinearGradientBrush",
            textHorizontalAlign: "TextHorizontalAlign",
            TextVerticalAlign: "TextVerticalAlign",
            number: "number",
            font: "font",
            string: "string"
        },       

        ControlSide: {
            WIDTH: 'width',
            HEIGHT: 'height'
        },        

        OrientationType: {
            Horizontal: 'Horizontal',
            Vertical: 'Vertical'
        },

    

        ParameterRoles: parameterRoles,

        serverState: {
            timeToSetValues: 'timeToSetValues',
            sendGlobalCounter: 'sendGlobalCounter',
            connectionError: 'connectionError',
            SubscriptionId: 'SubscriptionId',
            Connected: 'Connected',
            IsValuesAdded: 'IsValuesAdded',
            requestedPublishingInterval: 'requestedPublishingInterval',
            requestedLifetimeInterval: 'requestedLifetimeInterval',
            maxNotificationsPerPublish: 'maxNotificationsPerPublish',
            maxSize: 'maxSize',
            ackSequenceNumber: 'ackSequenceNumber',
            wasRecconected: 'wasRecconected',
            taskId: 'taskId',
            itemId: 'itemId',
            path: 'path',
            serverTime : 'serverTime'
        },
        EndpointType: {
            source: 'source',
            target: 'target'
        },

        ActionType: {
            alert: 'Alert',
            callPOU: 'CallPOU',
            changeConditionState: 'ChangeConditionState',
            login: 'Login',
            logout: 'Logout',
            setParameterValue: 'SetParameterValue',
            setFirstPage: 'SetFirstPage',
            setLastPage: 'SetLastPage"',
            setPrevPage: 'SetPrevPage',
            setNextPage: 'SetNextPage',
            callEvent: 'CallEvent',
            openDialog: 'OpenDialog',
            openWindow: 'OpenWindow',
            callMethod: 'CallMethod',
            fullScreen: 'FullScreen',
            closeDialog: 'CloseDialog',
            backward: 'Backward',
            forward: 'Forward',
            showTaskBar: 'ShowTaskBar',
            openPrintDialog: 'OpenPrintDialog',
            openUrl: 'OpenUrl'
        },

        methodType: {
            _Sleduyuschaya_stranica: 'nextPage',
            _Prediduschaya_stranica: 'previousPage',

            _Pervaya_stranica: 'firstPage',
            _Poslednyaya_stranica: 'lastPage',

            _Prediduschee_soobschenie: 'previousMessage',
            _Sleduyuschee_soobschenie: 'nextMessage',

            _Obnovitj: 'refresh',

            _Kvitirovatj_soobschenie: 'ackEvents',
        },

        EventType: {
            click: 'Click',
            doubleClick: 'DoubleClick',
            focus: 'Focus',
            lostFocus: "LostFocus",
            keyPress: "KeyPress",
            keyDown: "KeyDown",
            keyUp: "KeyUp",
            mouseDown: "MouseDown",
            mouseUp: "MouseUp",
            mouseEnter: "MouseEnter",
            mouseLeave: "MouseLeave",
            mouseMove: "MouseMove",
            mouseWheel: "MouseWheel",
            contextMenu: 'ContextMenuOpening',
        },

        SwipeDirection: {
            swipeLeft: 'SwipeLeft',
            swipeRight: 'SwipeRight'
        },

        PinchDirectional: {
            pinchIn: 'PinchIn',
            pinchOut: 'PinchOut',
            pinchEnd: 'PinchEnd',
            pinchMove: 'PinchMove',
            pinchStart: 'PinchStart'
        },

        ParametersSource: {
            gesture: 'Gesture'
        },

        PanType: {
            panStart: 'PanStart',
            panEnd: 'PanEnd',
        },

        PanDirectional: {
            panRight: 'PanRight',
            panLeft: 'PanLeft'
        },

        EventParameters: {
            X: 'X',
            Y: 'Y',
            Z: 'Z',
            MouseLB: 'MouseLB',
            MouseMB: 'MouseMB',
            MouseRB: 'MouseRB',
            Key: 'Key',
            KeyCode: 'KeyCode'
        },

        TrendEvents: {
            draw: 'draw',
            refresh: 'refresh',
            init: 'init',
            position: 'position',
            beforeRender: 'beforeRender',
            afterRender: 'afterRender',
            drawTicks: 'drawTicks',
            selectTrendline: 'selectTrendline',
            drawCursor: 'drawCursor',
            trendlineVisibility: 'trendlineVisibility'
        },

        GlobalEventsTypes: {
            resourceFetched: 'resourceFetched',
            online: 'online',
            offline: 'offline',
            languageChanged: 'languageChanged',
            reloadProject: 'reloadProject',
            clientErrorOccured: 'clientErrorOccured',
            showTaskBar: 'showTaskBar'
        },

        ConditionType: {
            predefined: "predefined",
            user: "user"
        },

        ComparerType: {
            more: "More",
            less: "Less",
            lessEqual: "LessEqual",
            moreEqual: "MoreEqual",
            equal: "Equal",
            notEqual: "NotEqual"
        },

        ConditionState: {
            set: 'set',
            unset: 'unset'
        },

        ConvertationType: {
            number: 'number',
            enum: 'enum',
            string: 'string',
            brush: 'brush',
            boolean: 'boolean'
        },        

        logLevel: {
            error: 32, //OPCUA_TRACE_LEVEL_ERROR   
            waring: 16, //OPCUA_TRACE_LEVEL_WARNING   
            system: 8, // OPCUA_TRACE_LEVEL_SYSTEM 
            info: 4, //OPCUA_TRACE_LEVEL_INFO       
            debug: 2, // OPCUA_TRACE_LEVEL_DEBUG      
            content: 1 // OPCUA_TRACE_LEVEL_CONTENT     
        },

        BrowserPrefix: {
            Moz: 'moz',
            Opera: 'o',
            WebKit: 'webkit',
            IE: 'ie',
            MS: '-ms-'
        },

        LineStyle: {
            solid: 'solid',
            dashed: 'dashed',
            dotted: 'dotted'
        },

        DataQuality: {
            good: 0,
            bad: 1
        },

        ServerVariablesProperties: {
            sourceTime: 'sourceTime',
            statusCode: 'statusCode'
        },

     

        // Function blocks
        ParameterAccess: {
            Local: 1,
            In: 2,
            Out: 4,
            InOut: 8
        },
        Button: {
            State: "ButtonState",
            Up: "Up",
            Down: "Down",
            Over: "Over",
            Disabled: "Disabled"
        },

        PredefinedColors: {
            aliceblue: '#f0f8ff',
            antiquewhite: '#faebd7',
            aqua: '#00ffff',
            aquamarine: '#7fffd4',
            azure: '#f0ffff',
            beige: '#f5f5dc',
            bisque: '#ffe4c4',
            black: '#000000',
            blanchedalmond: '#ffebcd',
            blue: '#0000ff',
            blueviolet: '#8a2be2',
            brown: '#a52a2a',
            burlywood: '#deb887',
            cadetblue: '#5f9ea0',
            chartreuse: '#7fff00',
            chocolate: '#d2691e',
            coral: '#ff7f50',
            cornflowerblue: '#6495ed',
            cornsilk: '#fff8dc',
            crimson: '#dc143c',
            cyan: '#00ffff',
            darkblue: '#00008b',
            darkcyan: '#008b8b',
            darkgoldenrod: '#b8860b',
            darkgray: '#a9a9a9',
            darkgreen: '#006400',
            darkkhaki: '#bdb76b',
            darkmagenta: '#8b008b',
            darkolivegreen: '#556b2f',
            darkorange: '#ff8c00',
            darkorchid: '#9932cc',
            darkred: '#8b0000',
            darksalmon: '#e9967a',
            darkseagreen: '#8fbc8f',
            darkslateblue: '#483d8b',
            darkslategray: '#2f4f4f',
            darkturquoise: '#00ced1',
            darkviolet: '#9400d3',
            deeppink: '#ff1493',
            deepskyblue: '#00bfff',
            dimgray: '#696969',
            dodgerblue: '#1e90ff',
            firebrick: '#b22222',
            floralwhite: '#fffaf0',
            forestgreen: '#228b22',
            fuchsia: '#ff00ff',
            gainsboro: '#dcdcdc',
            ghostwhite: '#f8f8ff',
            gold: '#ffd700',
            goldenrod: '#daa520',
            gray: '#808080',
            green: '#008000',
            greenyellow: '#adff2f',
            honeydew: '#f0fff0',
            hotpink: '#ff69b4',
            indianred: '#cd5c5c',
            indigo: '#4b0082',
            ivory: '#fffff0',
            khaki: '#f0e68c',
            lavender: '#e6e6fa',
            lavenderblush: '#fff0f5',
            lawngreen: '#7cfc00',
            lemonchiffon: '#fffacd',
            lightblue: '#add8e6',
            lightcoral: '#f08080',
            lightcyan: '#e0ffff',
            lightgoldenrodyellow: '#fafad2',
            lightgray: '#d3d3d3',
            lightgreen: '#90ee90',
            lightpink: '#ffb6c1',
            lightsalmon: '#ffa07a',
            lightseagreen: '#20b2aa',
            lightskyblue: '#87cefa',
            lightslategray: '#778899',
            lightsteelblue: '#b0c4de',
            lightyellow: '#ffffe0',
            lime: '#00ff00',
            limegreen: '#32cd32',
            linen: '#faf0e6',
            magenta: '#ff00ff',
            maroon: '#800000',
            mediumaquamarine: '#66cdaa',
            mediumblue: '#0000cd',
            mediumorchid: '#ba55d3',
            mediumpurple: '#9370db',
            mediumseagreen: '#3cb371',
            mediumslateblue: '#7b68ee',
            mediumspringgreen: '#00fa9a',
            mediumturquoise: '#48d1cc',
            mediumvioletred: '#c71585',
            midnightblue: '#191970',
            mintcream: '#f5fffa',
            mistyrose: '#ffe4e1',
            moccasin: '#ffe4b5',
            navajowhite: '#ffdead',
            navy: '#000080',
            oldlace: '#fdf5e6',
            olive: '#808000',
            olivedrab: '#6b8e23',
            orange: '#ffa500',
            orangered: '#ff4500',
            orchid: '#da70d6',
            palegoldenrod: '#eee8aa',
            palegreen: '#98fb98',
            paleturquoise: '#afeeee',
            palevioletred: '#db7093',
            papayawhip: '#ffefd5',
            peachpuff: '#ffdab9',
            peru: '#cd853f',
            pink: '#ffc0cb',
            plum: '#dda0dd',
            powderblue: '#b0e0e6',
            purple: '#800080',
            red: '#ff0000',
            rosybrown: '#bc8f8f',
            royalblue: '#4169e1',
            saddlebrown: '#8b4513',
            salmon: '#fa8072',
            sandybrown: '#f4a460',
            seagreen: '#2e8b57',
            seashell: '#fff5ee',
            sienna: '#a0522d',
            silver: '#c0c0c0',
            skyblue: '#87ceeb',
            slateblue: '#6a5acd',
            slategray: '#708090',
            snow: '#fffafa',
            springgreen: '#00ff7f',
            steelblue: '#4682b4',
            tan: '#d2b48c',
            teal: '#008080',
            thistle: '#d8bfd8',
            tomato: '#ff6347',
            transparent: '#00ffffff',
            turquoise: '#40e0d0',
            violet: '#ee82ee',
            wheat: '#f5deb3',
            white: '#ffffff',
            whitesmoke: '#f5f5f5',
            yellow: '#ffff00',
            yellowgreen: '#9acd32'
        },

        serverType: {
            bool: "BOOL",
            byte: "BYTE",
            int: "INT",
            dint: "DINT",
            lint: "LINT",
            sint: "SINT",
            uint: "UINT",
            udint: "UDINT",
            ulint: "ULINT",
            usint: "USINT",
            real: "REAL",
            lreal: "LREAL",
            date: "DATE",
            dt: "DT",
            date_and_time: "DATE_AND_TIME",
            time: "TIME",
            tod: "TOD",
            time_of_day: "TIME_OF_DAY",
            dword: "DWORD",
            lword: "LWORD",
            word: "WORD",
            string: "STRING",
            gradient: "HMI.GradientColorType",
            color: "HMI.SolidColorType",
            color_matrix: "HMI.MatrixColorType",
            'auto': "auto"
        },

        type: {
            object: 'object',
            enum: 'enum',
            array: 'array',
            number: 'number',
            date: 'date',
            string: 'string',
            boolean: 'boolean',
            fb: 'fb',
            tod: 'tod',
            time: 'time'
        },       

        timeStampReturnType: {
            neither: 'Neither',
            source: 'Source'
        },

        fullScreenDirection:
        {
            enter: 'enter',
            exit: 'exit'
        },

        statisticType: {
            window: 'window'
        },

        queryType:
        {
            refreshData: 'RefreshData',
            createMonitoredDataItems: 'CreateMonitoredDataItems',
            deleteDataSubscription: 'DeleteDataSubscription',
            publishData: 'PublishData',
            writeData: 'WriteData',
            deleteMonitoredDataItems: 'DeleteMonitoredDataItems',
            getLoginData: 'GetLoginData',
            login: 'Login',
            getState: 'GetState',
            logout: 'Logout',
            getArchiveItems: 'GetArchiveItems',
            createDataSubscription: 'CreateDataSubscription',
            historyReadRaw: 'HistoryReadRaw',

            createMonitoredEvents: 'CreateMonitoredEvents',
            refreshEvents: 'RefreshEvents',
            deleteEventSubscription: 'DeleteEventSubscription',
            publishEvents: 'PublishEvents',
            deleteMonitoredEvents: 'DeleteMonitoredEvents',
            createEventSubscription: 'CreateEventSubscription',
            getArchivedEvents: 'GetArchivedEvents',
            get: 'Get',
            put: 'Put',
            logMessage: 'LogMessage'
        },

        taskType: {
            st: 'st'
        },

        access: {
            local: 'local',
            input: 'input',
            output: 'output'
        },

        geometryType: {
            SVG_BORDER_RECT: 'RECT',
            SVG_BORDER_OVAL: 'OVAL',

        },

        pathSyntaxCommandElementType: {
            None: 'None',
            Setting: 'Setting',
            Width: 'Width',
            Height: 'Height',
            X: 'X',
            Y: 'Y'
        },

        pathCommand: {
            F: 'F',
            M: 'M',
            L: 'L',
            H: 'H',
            V: 'V',
            C: 'C',
            Q: 'Q',
            S: 'S',
            T: 'T',
            A: 'A',
            Z: 'Z'
        },

        pathCommandType: {
            Relative: 'Relative',
            Absolute: 'Absolute'
        },

        actionConnectionBehaviour: {
            onStartEnd: 'onaction',
            permanent: 'permanent'
        },

        eventType: {
            taskExecuted: 'TaskExecuted',
            serverDataReady: 'ServerDataReady',
            sourceDataReady: 'SourceDataReady'
        },

        variablesManagersTypes: {
            json: 'JSON',
            odata: 'ODATA',
            soap: 'SOAP',
            masterPLC: 'MASTERPLC',
            soap: 'SOAP'
        },

        variablesManagersSubTypes: {
            scheme: 'Scheme',
            trend: 'Trend'
        },

        connectionSearchType: {
            source: 'Source',
            target: 'Target',
            both: 'Both'
        },

        constants: {
            HEARTBEAT_MANAGER: 'HeartbeatManager'
        },

        autoscrollStopReason: {
            sortChange: 'sortChange',
            pageChange: 'pageChange',
            scrollChange: 'scrollChange',
            none: 'none'
        },

        fbType: {
            ScreenTask: 'ScreenTask',
            MasterPLC: 'MasterPLC'

        }

    };

    
    var processEditorEnums = function () {
        var i;
        for (typeName in Types) {
            if (Types[typeName].type === 'enum') {
                var rtTypeName = typeName;                

                switch (typeName) {
                    case "HMI.HorizontalAlignType":
                        rtTypeName = "TextHorizontalAlignment";
                        break;
                    case "HMI.VerticalAlignType":
                        rtTypeName = "TextVerticalAlignment";
                        break;
                    case "HMI.HorizontalAlignTypeExt":
                        rtTypeName = "HorizontalElementsAlign";
                        break;
                    case "HMI.VerticalAlignTypeExt":
                        rtTypeName = "VerticalElementsAlign";
                        break;
                    case "HMI.DateTimeType_Full":
                        rtTypeName = "DateTimeType";
                        break;
                    default:
                        if (typeName.substring(0, 3) === "HMI") {
                            rtTypeName = typeName.substring(4);
                        }
                        break;
                }

                if (!enums[rtTypeName]) {                    
                    enums[rtTypeName] = {};
                }

                var values = Types[typeName].description.values;
                for (i = 0; i < values.length; i++) {
                    enums[rtTypeName][values[i]] = i;                    
                }
            }
        }        
    }();

    return enums;
});