﻿define(['common/Enums', 'common/Error', 'common/Utilites'], function (Enums, Error, Utilites) {
    var PathSyntaxCommand = Class.extend({
        commandType: {
            Absolute: 'Absolute',
            Relative: 'Relative'
        },

        pathSplitRegx :/\s+|,/,

        init: function (type) {
            this.type = type;
            this.argsCount = 0;
            this.elements = []
        },

        normalize: function(width, height, maxWidthElement, maxHeightElement) {
            _.forEach(this.elements, function(element) {
                if (element.type == Enums.pathSyntaxCommandElementType.Width
                || element.type == Enums.pathSyntaxCommandElementType.X) {
                    element.value = String.format('{0:f2}', width * Number(element.value) / maxWidthElement);
                }
                else if (element.type == Enums.pathSyntaxCommandElementType.Height
                || element.type == Enums.pathSyntaxCommandElementType.Y) {
                    element.value = String.format('{0:f2}', height * Number(element.value) / maxHeightElement);
                }
            }, this);
        },

        getStringRepresentation: function() {
            var argsCount = this._getArgsCount();
            var pattern = this.getCommand();
            if (argsCount > 0) {
                if (this.elements.length % argsCount != 0) {
                    Error.onerror("Invalid args count for repeating comand.");
                    return;
                }

                var count = this.elements.length / argsCount,
                    i;

                for (i = 0; i < count; ++i) {
                    var elms = this.elements.slice(i * argsCount).slice(0, argsCount);
                    elms = elms.map(function (el) {
                        return el.getValue()
                    });

                    pattern = [pattern, String.formatByArray(this.getPattern(), elms)].join(' ');
                }
            }

            return pattern;
        },

        parse: function(args){
        },

        getPattern: function() {
            return '';
        },

        getCommand: function(){
            return '';          
        },

        getElements: function() {
            return this.elements;
        },

        _getCommandString: function () {
            switch (this.type) {
                case this.commandType.Absolute:
                    return this.getCommand();
                case this.commandType.Relative:
                    return this.getCommand().toLowerCase();
                default:
                    return '';
            }
        },
        
        _getArgsCount: function() {
            if (this.argsCount === 0) {
                var i,
                    pattern = this.getPattern();
                for(i = 0; i < pattern.length; i++){
                    if (Utilites.isNumber(pattern[i])) {
                        this.argsCount++;
                    }
                }
            }

            return this.argsCount;
        },

        _splitPath: function(path) {
            return _.compact(path.split(this.pathSplitRegx));
        }
    });

    return PathSyntaxCommand;
});