// <copyright file="ClockControl.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['controls/120218/120218Type', 'controls/CustomSvg/CustomSvgModel', 'controls/CustomSvg/CustomSvgController', 
    'core/Statistic', 'common/Enums'],
 function (controlType, CustomSvgModel, CustomSvgController,  Statistic, Enums) {
     
     var html ='<embed type=image/svg+xml svgattr="svgattr"></embed>'

     return function (parentResourceManager) {
         var statisticId = Statistic.startMeasurement(Enums.statisticType.window);
         return $$({
             model: new CustomSvgModel(controlType, parentResourceManager),
             view: {
                 format: html
             },
             controller: new CustomSvgController(statisticId)
         });
     };
 });
