﻿// <copyright file="ButtonController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

define(['when','common/Enums', 'common/Appearence', 'base/TextControlController'], function (when, Enums, Appearence, TextControlController) {
    var coefficients = { //ax+b
        upA: 1,
        upB: 0,
        downA: 1.25,
        downB: 100,
        overA: 1.1,
        overB: 25
    }
    var ButtonController = TextControlController.extend({
        init: function () {
            this._super();
            this.ClassName = 'ButtonController';
            this.modelChanged[Enums.ParameterRoles.IS_PRESSED] = this.onPressedChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_COLOR] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_THIKNESS] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.IS_ENABLED] = this.onIsEnabledChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_STYLE] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BACKGROUND_COLOR] = this.onButtonStateChanged.bind(this); 
            this.modelChanged[Enums.ParameterRoles.IS_FIXED] = this.onIsFixedChanged.bind(this);
            this.modelChanged[Enums.Button.State] = this.onButtonStateChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
        },
        onAddedToDOM: function () {
            this._super();
            if (this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                this.modelChanged[Enums.Button.State] = this.onSvgButtonStateChanged.bind(this);
            }
            this.isCovered = false;
            this.calculateFontSizeRatio();
            this.applyFontSize();
            this.onPressedChanged(this.mvc.model.getIsPressed());
        },

        onBackgroundColorChanged: function (value) {
            Appearence.background.apply(this.mvc.view.$(), value);
            this.onShadowChanged();
        },

        applyTextShadow: function () {
            var bg = this.mvc.model.getBackgroundColor();
            if (Appearence.color.parse(bg).brushType == "Solid" && Appearence.color.ARGBtoObj(bg).a == 0) {
                if (Appearence.color.ARGBtoObj(this.mvc.model._data.TextColor.value).a != 0) {
                    Appearence.shadow.applyTextShadow(this.textElement(), {
                        color: this.mvc.model.getShadowColor(),
                        size: this.mvc.model.getShadowSize()
                    });
                } else {
                    this.textElement().css('text-shadow', "");
                }
            }
        },

        onIsEnabledChanged: function (value) {
            this._super(value);
            this.modelChanged[Enums.Button.State]();
        },

        onSvgButtonStateChanged: function (state) {
            switch (this.getButtonState()) {
                case Enums.Button.Up:
                    this.onCustomParameterChanged("down:display:style", "none");
                    this.onCustomParameterChanged("over:display:style", "none");
                    this.onCustomParameterChanged("up:display:style", "inline");
                    break;
                case Enums.Button.Down:
                    this.onCustomParameterChanged("down:display:style", "inline");
                    this.onCustomParameterChanged("over:display:style", "none");
                    this.onCustomParameterChanged("up:display:style", "none");
                    break;
                case Enums.Button.Over:
                    this.onCustomParameterChanged("down:display:style", "none");
                    this.onCustomParameterChanged("over:display:style", "inline");
                    this.onCustomParameterChanged("up:display:style", "none");
                    break;
            }
        },

        getButtonState: function () {
            if (!this.mvc.model.getIsEnabled()) {
                return Enums.Button.Disabled;
            }
            if (this.mvc.model.getIsPressed()) {
                return Enums.Button.Down;
            }
            else
                if (this.isCovered) {
                    return Enums.Button.Over;
                }
                else {
                    return Enums.Button.Up;
                }
        },
        onIsFixedChanged: function(value){
            if (this.mvc.model.get(Enums.ParameterRoles.IS_FIXED)) {
                var ua = navigator.userAgent.toLowerCase();
                isAndroid = ua.indexOf("android") != -1;
                if (isAndroid) {
                    this.mvc.view.$().off('mouseenter');
                    this.mvc.view.$().off('mouseleave');
                }
                this.doOnMouseDown = this.switchPress;
                this.doOnMouseUp = function () { };
                this.doOnMouseLeave = function () { };
            } else {
                this.doOnMouseDown = this.press;
                this.doOnMouseUp = this.unpress;
                this.doOnMouseLeave = this.unpress;
                this.mvc.model.setIsPressed(false);
            }
        },
        onBorderChanged: function () {
            if (this.mvc.model.getBorderStyle() != Enums.BorderStyleType.Solid) {
                this.applyBorder();
                return;
            }
            if (this.mvc.model.getIsPressed()) {
                this.mvc.view.$().css('border-width', this.mvc.model.getBorderThickness());
                this.mvc.view.$().css('border-style', 'inset');
                this.mvc.view.$().css('border-color', this.mvc.model.getBorderColor());
            }
            else {
                this.mvc.view.$().css('border-width', this.mvc.model.getBorderThickness());
                this.mvc.view.$().css('border-style', 'outset');
                this.mvc.view.$().css('border-color', this.mvc.model.getBorderColor());
            }
        },
        onPressedChanged: function (value) {
            this.modelChanged[Enums.Button.State]();
            this.modelChanged[Enums.ParameterRoles.BORDER_STYLE](value);            
        },

        allowAct: function() {  
            if (Enums.ParameterRoles.IS_FIXED)
                this.mvc.model.setIsPressed(!(this.mvc.model.getIsPressed()));
            return when.resolve();       
        },

        textElement: function () {
            return this.mvc.view.$();
        },

        onButtonStateChanged: function (state) {
        	switch (this.getButtonState()) {
                case Enums.Button.Up:
                    this.onBackgroundColorChanged(this.mvc.model.getBackgroundColor());
                    this.onBorderChanged();
                    this.onTextColorChanged(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR));
                    break;
                case Enums.Button.Down:
                    this.onBackgroundColorChanged(Appearence.background.calculateColor(this.mvc.model.getBackgroundColor(), coefficients.downA, coefficients.downB));
                    this.onBorderChanged();
                    this.onTextColorChanged(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR));
                    break;
                case Enums.Button.Over:
                    this.onBackgroundColorChanged(Appearence.background.calculateColor(this.mvc.model.getBackgroundColor(), coefficients.overA, coefficients.overB));
                    this.onBorderChanged();
                    this.onTextColorChanged(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR));
                    break;
                case Enums.Button.Disabled:
                    this.onBackgroundColorChanged(Appearence.color.makeDisabled(this.mvc.model.getBackgroundColor()));
                    this.makeBorderDisabled();
                    this.onTextColorChanged(Appearence.color.makeDisabled(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR)));
                    break;
            }
        },

        onIsVisibleChanged: function (value) {
            if (value) {
                this.mvc.view.$().css('visibility', 'visible');
            }
            else {
                this.mvc.view.$().css('visibility', 'hidden');
            }
        },
        makeBorderDisabled: function () {
            var border = {
                penType: this.mvc.model.get(Enums.ParameterRoles.BORDER_STYLE),
                size: this.mvc.model.get(Enums.ParameterRoles.BORDER_THIKNESS),
                color: Appearence.background.calculateColor(Appearence.color.makeGrayscale(this.mvc.model.get(Enums.ParameterRoles.BORDER_COLOR)), coefficients.disableA, coefficients.disableB)
            };

            Appearence.border.applyBorder(this.mvc.view.$(), border);
        },
        onMouseDownNotFixed: function (event) {
        	this.mvc.model.setIsPressed(true);
            this._super(event);
        },
        unpress: function (event) {
            this.mvc.model.setIsPressed(false);
        },
        press: function(event){        	
            this.mvc.model.setIsPressed(true);
        },
        switchPress: function (event) {
        	this.askConfirmation();
        },
        onMouseUp: function (event) {
            this.doOnMouseUp();
            this._super(event);
            this.modelChanged[Enums.Button.State]();
        },
        onMouseDown: function (event) {
            this.doOnMouseDown();
            this._super(event);
            this.modelChanged[Enums.Button.State]();
        },
        onMouseEnter: function (event) {
            this._super(event);
            this.isCovered = true;
            this.modelChanged[Enums.Button.State]();
        },
        onMouseLeave: function (event) {
            this.doOnMouseLeave();
            this.isCovered = false;
            this._super(event);
            this.modelChanged[Enums.Button.State]();
        }
    });
    return ButtonController;
});