﻿// <copyright file="ClockController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class ClockController controller class for Clock control
*/
define(['common/Enums', 'base/ControlController', 'common/Utilites', 'common/Appearence', 'common/Error', 'js!libs/svg/smil_user.js!order'], function (Enums, WindowController, Utilites, Appearence, Error) {
    //here we will define controller for button

    var CustomSvgController = WindowController.extend({

        init: function (statisticId) {
            this._super(statisticId);
            this.queue = [];
            this.notLoaded = false;
            this.ClassName = 'CustomSvgController';
            this.svgRoot = null;
        },

        onAddedToDOM: function () {
            this._super();
            if (Utilites.isWebkit() && !Utilites.isTablet()) {
                $(window).on('resize', this, this.onResize.bind(this));
            }
        },

        attachEvents: function () {
            this.mvc.model.subscribeOnInit(this.onModelInit, this);
            this.mvc.model.subscribeOnAfterInit(this.onAfterModelInit, this);

            var embed = this.mvc.view.$()[0];
            var svgContent = null;
            try {
                svgContent = embed.getSVGDocument();
            }
            catch (ex) {
                console.error(ex.message || ex);
            }

            //VictorM svg элементы подгружаются параллельно с подгрузкой основного документа. 
            //Поэтому может получиться, что к моменту вызова addSvgEventListener некоторые элементы уже загружены и по ним уже не вызовится onload
            if (svgContent != null) {
                this.addSvgEventListener(svgContent.querySelector('svg'));
                this.svgRoot = this._getSvgRoot(embed);
                registerAnimation(this.svgRoot);
            }
            else {
                embed.addEventListener('load', function () {
                    this.svgRoot = this._getSvgRoot(embed);
                    if (this.svgRoot) { //бывает возвращается null
                        this.addSvgEventListener.call(this, embed.getSVGDocument().querySelector('svg'));
                        if (this.notLoaded) {
                            if (Utilites.isWebkit()) {
                                $(embed.getSVGDocument().querySelector('svg')).css('transform', 'translate3d(0, 0, 0)');
                            }
                            registerAnimation(this.svgRoot);
                            for (var i in this.queue) {
                                this.queue[i].call(this);
                            }
                            this.queue = [];
                            this.notLoaded = false;
                        } else {
                            //браузер может перегрузить содержимое embeded
                            //и не всегда выставить назад все свойства
                            this._resetSVG();
                        }
                    } else {
                        Error.warn("svg DataControlId = " + this.mvc.model.getId() + " getSVGDocument=null");
                    }
                }.bind(this), false);
            }
        },
        _resetSVG: function(){
            var data = this.mvc.model._data;
            for (dataKey in data) {
                if (dataKey.indexOf('svg:') >= 0) {
                    this.onCustomParameterChanged(dataKey, this.mvc.model.get(dataKey), null);
                }
            }
            data = null;
        },
        applyShadow: function () {
            var shadow = {
                size: this.mvc.model.get(Enums.ParameterRoles.SHADOW_SIZE),
                color: this.mvc.model.getShadowColor()
            };
            var gray = this.mvc.model.getIsEnabled() ? 0: 100;
            this.mvc.view.$().css('filter', String.format('drop-shadow({0}px {0}px {1}px {2}) grayscale({3}%)', shadow.size, 0, shadow.color, gray));
        },

        onIsEnabledChanged: function (value) {
            this._super();
            this.applyShadow();
        },
        onResourceChanged: function (value) {
            //get resource url
            var resourceUrl;

            if (!value) {
                resourceUrl = null;
            }
            else {
                resourceUrl = this.mvc.model.resourceManager.resolve(value);
            }

            this.svgResourceLoaded = false;
            this.mvc.view.$().attr('src', resourceUrl);
        },

        calculateResizeProportions: function () {
            return;
        },
        addSvgEventListener: function (element, event, handler) {
            if (_.isEmpty(this.events)) { //есть ли события, иначе подписываться на них бесполезно
                this.mvc.view.$().css('pointer-events', 'none');
            } else {
                var self = this;
                var elem = $(element);

                elem.mousedown(function (event) { self.onMouseDown(event); });
                elem.mouseup(function (event) { self.onMouseUp(event); });
                elem.mouseover(function (event) { self.onMouseMove(event); });
                elem.mouseenter(function (event) { self.onMouseEnter(event); });
                elem.mouseleave(function (event) { self.onMouseLeave(event); });

                elem.click(function (event) { self.onClick(event); });
                elem.dblclick(function (event) { self.onDoubleClick(event); });

                elem.focusin(function (event) { self.onFocus(event); });
                elem.focusout(function (event) { self.onFocusLost(event); });

                elem.keypress(function (event) { return self.onKeyPress(event); });
                elem.keydown(function (event) { return self.onKeyDown(event); });
                elem.keyup(function (event) { return self.onKeyUp(event); });
            }
        },

        modelPropertyChangedInternal: function (event) {
            this._super(event);

            // path in format svg:id_of_element:property name
            if (event.property.indexOf('svg:') >= 0) {
                this.onCustomParameterChanged(event.property, this.mvc.model.get(event.property), event.oldValue);
            }
        },
        onIsVisibleChanged: function (value) {
            if (value) {
                this.mvc.view.$().css('visibility', 'inherit');
            }
            else
            {
                this.mvc.view.$().css('visibility', 'hidden');
            }
        },
        onCustomParameterChanged: function (path, value, oldValue) {
            if (this.svgRoot === null ||  this.notLoaded === true) {
                //  console.warn('No svg root');
                this.notLoaded = true;
            }

            if (this.notLoaded === false) {
                this._setSvgParameter(path, value, oldValue);
            } else {
                this.queue.push(function (path, value, oldValue) {
                    return function () {
                        this._setSvgParameter(path, value, oldValue);
                    }
                }(path, value, oldValue));
            }
        },
        
        onResize: function () {
            if (!window.initialized)
                return;
            var w = this.mvc.view.$()[0].style.width;
            this.mvc.view.$().width(0);
            this.mvc.view.$()[0].style.width = w;
        },

        _setSvgParameter: function (path, value, oldValue) {
            if (this.svgRoot === null) {
                console.warn('No svg root');
                return;
            }

            var tokenizedPath = path.split(':');
            var selector = this._getSelector(tokenizedPath[1]);

            if (tokenizedPath[2] === 'Content') {
                if (Utilites.isWebkit()) {
                    $(selector, this.svgRoot)[0].textContent = value;
                } else {
                    $(selector, this.svgRoot).html(value);
                }

            } else {
                this._getSetParameterMethod(tokenizedPath[3]).call($(selector, this.svgRoot), tokenizedPath[2], value);
                if (Utilites.isWebkit()) {
                    this.onResize();
                }
            }
        },

        _getSvgRoot: function (element) {
            try {
                if (element.getSVGDocument() !== null && element.getSVGDocument().readyState === 'complete') {
                    return element.getSVGDocument().documentElement;
                } else {
                    return null;
                }
            } catch (e) {
                Error.debug(String.format('Reason: {0} \n Stack trace: \n {1}', e.message || e, e.stack));
                return null;
            }
        },

        _isClassParameter: function (name) {
            return name.indexOf('.') === 0;
        },

        _getSelector: function (name) {
            if (this._isClassParameter(name)) {
                return name;
            } else {
                return '#' + name;
            }
        },

        _getSetParameterMethod: function (name) {
            if (name === null || name === undefined || name !== 'style') {
                return $.fn.attr;
            } else {
                return $.fn.css;
            }
        }
    });

    return CustomSvgController;
});
