﻿// <copyright file="ClockModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ClockModel model class for Clock control
*/
define(['common/Enums', 'base/ControlModel'],
function (Enums, WindowModel) {
    //here we will define model for button


    var CustomSvgModel = WindowModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'CustomSvgModel';
        },
        initModel: function (model, context, attachedProperties) {
            this.applyModel(model, context, attachedProperties);
            this.fireOnInit();

            this.fireAllPropertiesChanged();

            this.fireOnAfterInit();
        },
        _onValueMissing: function(msg){
        },

        getPropertyType: function (arg) {
            if (arg.indexOf("svg:") === 0) {
                return Enums.serverType.auto;
            }         

            return this._super(arg);
        },

        _getProperty: function (arg, isCopy, shouldExists) {
            if (arg.indexOf("svg:") === 0) {
                return this._super(arg, isCopy, false);
            }

            return this._super(arg, isCopy, shouldExists);
        }

    });

    return CustomSvgModel;
});
