﻿// <copyright file="Bottombar.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


//TODO L10n
define(['common/Enums', 'core/L10n'],
   function (Enums, L10n) {
       var placeholder = 'bottombar';
       var l10nPrefix = 'journalBottomBar.';

       var bottomBarProto = $$({
           placeholder: 'bottombar',
           _model: {
               unread: 0,
               deleted: 0,
               interval: ''
           },
           view: {
               format: '<div></div>'
           },
           _controller: {
           }
       });

       var BottomBar = Class.extend({
           init: function (messageHolder, journalModel) {
               bottomBarProto.view.format = '<div class="journal-bottom"><div><span>' + L10n.get(l10nPrefix + 'skipped') + ' </span><span data-bind="unread"></span> ' +
                 '<span> ' + L10n.get(l10nPrefix + 'interval') + '</span><span data-bind="interval"></span></div></div>';
               
               this.messageHolder = messageHolder;
               this.model = journalModel;
               this.Bottombar = null;
               this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
               this.messageHolder.subscribeMessagesUpdated(this._onMessagesChanged, this);

               this._createBottombar();
           },

           _createBottombar: function () {
               this.Bottombar = $$(bottomBarProto);
               this._onAutoscrollChanged();
           },

           render: function (container) {
               container.find(String.format('[placeholder="{0}"]', placeholder))
                   .append(this.Bottombar.view.$());
           },

           onModelPropertyChanged: function (event) {
               switch (event.property) {
                   case Enums.ParameterRoles.AUTOSCROLL:
                       this._onAutoscrollChanged();
                       break;
                   case Enums.ParameterRoles.RIGHT_BORDER:
                   case Enums.ParameterRoles.LEFT_BORDER:
                       this._onPageIntervalChanged();
                       break;
               }
           },

           _onMessagesChanged: function (event) {
               if (!this.model.getAutoScroll() && !event.isArchive) {
                   var newMessagesCnt = event.skippedMessages ? event.skippedMessages.length : 0;
                   this.Bottombar._model.set({
                       unread: this.Bottombar._model.get('unread') + newMessagesCnt
                   });
               }
           },

           _onAutoscrollChanged: function () {
               if (this.model.getAutoScroll()) {
                   this.Bottombar.view.$().hide();
                   this.Bottombar._model.set({
                       unread: 0,
                       deleted: 0
                   });
               } else {
                   this.Bottombar.view.$().show();
               }
           },

           _onPageIntervalChanged: function () {             
               this.setInterval(this.model.getLeftBorder(), this.model.getRightBorder());
           },

           setInterval: function (start, end) {
               var startD = new Date(start),
                   endD = new Date(end);

               this.Bottombar._model.set({
                   interval: String.format('{0:HH:mm:ss dd.MM.yyyy} - {1:HH:mm:ss dd.MM.yyyy}', startD, endD)
               });
           }

       });

       return BottomBar;
   });