﻿// <copyright file="ToggleFullscreen.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([], function () {

    ///element - must be jQuery object
    ///value - true | false
    function ToggleFullscreen(element, value) {

        var cssRule = window.FullScreenMode = 'scheme' ? 'journal-full-screen-scheme' : 'journal-full-screen-browser';

        if (value) {
            element.addClass(cssRule);
        }
        else {
            element.removeClass(cssRule);
        }

        if (window.FullScreenMode == 'browser') {
            if (value) {
                jQuery.data(element[0], 'fullscreen_old_size', { width: element.css('width'), height: element.css('height') });

                element.width(window.innerWidth);
                element.height(window.innerHeight);
            }
            else {
                var oldSize = jQuery.data(element[0], 'fullscreen_old_size');
                jQuery.data(element[0], 'fullscreen_old_size', null);

                element.css('width', oldSize.width);
                element.css('height', oldSize.height);
            }
        }
    }

    return ToggleFullscreen;
});

