﻿// <copyright file="DetailPanel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums',
    'common/Appearence',
    'helpers/PathBuilder',
    'controls/Journal/modules/details/Detail'],
    function (Enums, Appearence, PathBuilder, Detail) {
    var placeholder = 'details';

    var detailsProto = {
        _model: {},
        view: {
            format: '<div class="journal-details"><table><tbody></tbody></table></div>',
        }
    };

    var DetailsPanel = Class.extend({
        init: function (messageHolder, journalModel) {
            this.messageHolder = messageHolder;
            this.model = journalModel;
            this.detailsPanel = null;
            this.details = [];
            this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
            this.messageHolder.subscribeMessageSelected(this._onMessageSelected, this);
            this.messageHolder.subscribeMessagesUpdated(this._onMessagesUpdated, this);
            this.height = null;

            this._createDetailsPanel();
        },

        _createDetailsPanel: function () {
            this.detailsPanel = $$(detailsProto);
            var i,
                legendColumns = this.model.getLegendColumns();
            for (i = 0; i < legendColumns.length; i++) {
                this.details.push(new Detail(i, this.model));
            }
        },

        render: function (container) {
            for (var i = 0; i < this.details.length; i++) {
                this.details[i].render(this.detailsPanel.view.$());
            }

            container.find(String.format('[placeholder="{0}"]', placeholder))
                .append(this.detailsPanel.view.$());
            this.height = this.detailsPanel.view.$().height();
            this._onShowLegendChanged();
        },

        _onMessageSelected: function (event) {
            if (event.message) {
                _.forEach(this.details, function (detail) {
                    detail.setMessage(event.message);
                }, this);
            } else {
                _.forEach(this.details, function (detail) {
                    detail.clearValue();
                }, this);
            }
           
        },

        _onMessagesUpdated: function (event) {
            if (this.messageHolder.selectedMessage) {
                this._onMessageSelected({ message: this.messageHolder.selectedMessage });
            }
        },

        onModelPropertyChanged: function (event) {
            var pathArray = new PathBuilder(event.property).getArray();
            if (pathArray[0] === Enums.ParameterRoles.SHOW_LEGEND) {
                this._onShowLegendChanged();
            }
        },

        _onShowLegendChanged: function () {
            Appearence.applyVisibility(this.detailsPanel.view.$(),
                this.model.get(Enums.ParameterRoles.SHOW_LEGEND));
        },

        getHeight: function(){
            return  this.height;
        },

        setHeight: function (height) {
            this.detailsPanel.view.$().height(height);
        }
    });

    return DetailsPanel;
});