﻿// <copyright file="Scroll.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([], function () {
    return function (that, messageHolder, journalModel) {
        var scroll = $$({
            _model: {},
            view: {
                format: '<div class="journal-grid-scroll"><div>'
            },
            _controller: {},
            init: function (height) {
                this.view.$()
                    .width(this.width);
                this.height = height;
                this.view.$()
                    .height(height);               
                this.slider = this.view.$('div')
                    .slider({
                        min: 0,
                        max: 255,
                        value: 255,
                        orientation: "vertical"
                    }).bind("slide slidechange", function (e, ui) {
                    //вверху слайдера максимум
                    //поэтому переворачиваем
                    this.sliderPosition =
                        this.slider.slider("option").max - ui.value;

                    //если это скролл от пользователя 
                    that._onScrollpositionChanged(e.originalEvent!==undefined);                   
                }.bind(this))
                    .mousewheel(function (e, delta) {
                        this.onMouseWheel(e, delta);
                        return false;
                    }.bind(this));
               // this.view.$('div')
                //     .height(height);
                this.applyHeight();
                this.view.$()
                    .hide();
            },
            onMouseWheel: function (e, delta) {
                if (this.visible) {
                    this.slider.slider("value", this.slider.slider("value") + delta, e);
                    return false;
                }
            },
            updateHeight: function (height) {
                this.height = height;
                this.applyHeight();
                var oldmax = this.slider.slider("option", "max");
                var oldposition = this.slider.slider("option", "value");
                that.updateScrollStatus();
                var newmax = this.slider.slider("option", "max");
                var newposition = Math.ceil((newmax * oldposition) / oldmax);
                this.slider.slider("value", newposition);

            },
            setMax: function (max) {
                //this.slider.slider("option", "value", max);
                this.slider.slider("option", "max", max);
                this.max = max;
            },
            setPosition: function (value) {
                this.slider.slider("option", "value", value);
            },
            
            setSliderPosition: function (value) {
                //вверху 0, внизу max
                this.slider.slider("option", "value",
                    this.slider.slider("option").max - value);
            },

            isAtTop: function () {
                return this.slider.slider("option", "value") === this.slider.slider("option", "max");
            },
            applyHeight: function () {
                this.view.$()
                    .height(this.height);
                this.view.$('div.ui-slider')
                    .height(this.height - 25);
            },
            scrollToStart: function () {
                this.slider.slider("option", "value", this.max);
            },
            scrollToEnd: function () {
                this.slider.slider("option", "value", 0);
            },
            changePosition: function (delta) {
                //console.log(this.slider.slider("value"));
                //console.log(delta);
                var val = this.slider.slider("value") + delta;
                this.slider.slider("value", val);
            },
            show: function () {
                // Vlad: пока немного костыльну-добавлю проверку. 
                // вообще, нельзя допускать ситуаций, когда этот метод вызывается на еще не инициализированном объекте
                if (this.slider !== null) {
                    this.view.$()
                        .show();
                    this.visible = true;
                    this.slider.slider("enable");
                }
            },
            hide: function () {
                // Vlad: пока немного костыльну-добавлю проверку. 
                // вообще, нельзя допускать ситуаций, когда этот метод вызывается на еще не инициализированном объекте
                if (this.slider !== null) {
                    this.view.$()
                        .hide();
                    this.visible = false;
                    this.slider.slider("disable");
                }
            },
            visible: true,
            width: 20,
            height: 0,
            headerHeight: 0,
            slider: null,
            sliderPosition: 0,
            max: 0
        });

        return scroll;
    }
});