﻿// <copyright file="Body.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['controls/Journal/modules/GridHelper', 'common/Appearence'],
    function (helper, Appearence) {
        return function (that, messageHolder, journalModel) {
        var keyField = 'EventId';
        var body = $$({
            _model: {},
            view: {
                format: '<tbody></tbody>'
            },
            applyRowsColumnsStyles: function (columnsStyles) {
                this.rows.forEach(function (row) {
                    row.applyRowColumnStyles(columnsStyles);
                });
            },
            selectRow: function (eventId) {
                for (var i = 0; i < this.rows.length; i++) {
                    if (this.rows[i]._model.get(keyField) == eventId) {
                        this.selectedRow = this.rows[i];
                        this.selectedRowEventId = eventId;
                        this.rows[i].setSelected();
                        break;
                    }
                }
            },
            cancelSelectedRowStyle: function () {
                if (this.selectedRow) this.selectedRow.setNormal();
            },
            updateSelectedRowStyle: function () {
                if (this.selectedRowEventId == -1) {
                    return;
                }

                this.selectRow(this.selectedRowEventId);
            },
            adddRow: function (row) {
                this.append(row);
                this.rows.push(row);
            },
            cancelSelection: function () {
                if (this.selectedRow) {
                    this.selectedRow.setNormal();
                }
                this.selectedRowEventId = -1;
            },
            updateViewPortRows: function () {
                var rowStyles = helper.updateStyles(journalModel.getRowStyle());
                //формируем viewport
                var viewPortMaxHeight = this.table.getInnerHeight();
                //а вот при выключенном скролее, не хотелось бы перейти на кусок сообщения
                var viewPortRowsCountMin = Math.floor(viewPortMaxHeight / this.rowHeight);
                //Этап 1 - предварительное добалвение/удаление строк
                //Он нужен для оптимизации, т.к постоянно спрашивать высоту - дорого.
                var update = viewPortRowsCountMin - this.rows.length;
                if (update > 0) {
                    //добавляем недостающие
                    for (var i = 0; i < update; i++) {
                        var row = $$(that.rowTemplate);
                        this.adddRow(row);
                    }
                    //применяем стили к строкам       
                    this.applyRowStylesBlock();
                }
                if (update < 0) { //удаляем лишнее
                    var removed = this.rows.splice(1, -update);
                    for (var i = 0; i < removed.length; i++) {
                        removed[i].destroy();
                    }
                }

                //если журнал сжали так, что не помещается ни одна строка
                if (viewPortMaxHeight < 0) {
                    return update;
                }

                var i;
                for (i = 0; i < this.rows.length; i++) {
                    this.rows[i].view.$()
                            .css(rowStyles);
                    this.rows[i].view.$().css('display', '');
                }

                //Этап 2 - точная подгонка кол-ва строк
                //строк не хватает - добавляем
                if (viewPortMaxHeight > this.getHeight()) {
                    while (viewPortMaxHeight > this.getHeight()) {
                        var row = $$(that.rowTemplate);
                        row.view.$()
                            .css(rowStyles);
                        this.adddRow(row);
                    }
                }
                //если строки лишние - убираем
                var h = this.getHeight();
                if (viewPortMaxHeight < h) {
                    while (viewPortMaxHeight < h) {
                        var removedRow = this.rows.splice(0, 1);
                        removedRow[0].destroy();
                        h = this.getHeight();
                    }
                }
                this.applyRowStylesBlock();
                var height = this.getHeight();
                this.table.scroll.updateHeight(height);
                this.table.updateViewPortHeight(height);
                return update;
            },
            initRowRoughHeigth: function () {
                //ставляем фейковую строку, что бы узнать ее примерную высоту в браузере
                var row = $$(that.rowTemplate);
                var rowStyles = helper.updateStyles(journalModel.getRowStyle());
                row.view.$()
                    .css(rowStyles);
                this.append(row);
                this.applyRowStylesBlock();
                var columnsStyles = helper.getColumnsStyles(that.columns, this.table.getInnerWidth());
                this.table.applyColumnsStyles(columnsStyles);
                this.rowHeight = row.view.$()
                    .outerHeight(true);
                row.destroy();
            },
            applyRowStylesBlock: function () {
                var rows = this.view.$('tr');
                if (rows.length == 0)
                    return;
                var rowStyles = helper.updateStyles(journalModel.getRowStyle());
                var backgroundColor = rowStyles['BackgroundColor'];
                delete rowStyles['BackgroundColor'];

                rows.css(rowStyles);
                Appearence.background.apply(rows, backgroundColor);

                if (rowStyles.height) {
                    rows.children('td')
                        .children('div:not(.journal-grid-confirm-div)')
                        .height(rowStyles.height);
                }
            },

            getHeight: function () {
                return this.view.$()
                    .height();
            },
            selectedRow: null,
            selectedRowEventId: -1,
            rows: [],
            scrollTop: 0,
            rowHeight: 1,
            table: null
        });
        
        return body;
    }
});