﻿// <copyright file="TaskBarController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// _completedRequest

define(['common/Enums', 'controls/StackPanel/StackPanelController',
    'core/global/GlobalEvents', 'controls/ErrorsPopup/ErrorsPopupControl'],
    function (Enums, StackPanelController, GlobalEvents, ErrorsPopup) {
        var online = 'online',
            offline = 'offline',
            clientError = 'error';


    var TaskBarController = StackPanelController.extend({

        init: function () {
            this._super();
            GlobalEvents.addListener(Enums.GlobalEventsTypes.online, this._handleOnlineStatus, this);
            GlobalEvents.addListener(Enums.GlobalEventsTypes.offline, this._handleOfflineStatus, this);
            GlobalEvents.subscribeClientErrorOccured(this._onClientErrorOccured, this);
            this.ClassName = 'TaskBarController';
            this.wasOffline = true;
        },

        onAddedToDOM: function(){
            this._super();
            if (this.mvc.model.getAutoPopUp()) {
                this._hideTaskBar();
            }
        },

        modelPropertyChangedInternal: function (event) {

            this._super(event);

            switch (event.property) {
                case Enums.ParameterRoles.ANCHOR: {
                    this.onAnchorChanged(event);
                    this.renderOrientation();
                    break;
                }
                case Enums.ParameterRoles.AUTO_POPUP:
                    this.onAutoPopUpChanged(event);
                    break;
            }
        },

        onAutoPopUpChanged: function (event) {
            if (this.mvc.model.getAutoPopUp()) {
                this._getCloseButton().css('visibility', 'visible');
            } else {
                this._getCloseButton().css('visibility', 'hidden');
            }
        },

        onAnchorChanged: function (event) {
            switch (this.mvc.model.getAnchor()) {
                case Enums.AnchorType.Down:
                    this.mvc.view.$().css({ bottom: 0 }); break;
                case Enums.AnchorType.Left:
                    this.mvc.view.$().css({ left: 0 }); break;
                case Enums.AnchorType.Right:
                    this.mvc.view.$().css({ right: 0 }); break;
                case Enums.AnchorType.Up:
                    this.mvc.view.$().css({ top: 0 }); break;
                default:
                    this.mvc.view.$().css({ bottom: 0 }); break;
            }
        },

        renderOrientation: function () {
            switch (this.mvc.model.getAnchor()) {
                case Enums.AnchorType.Down:
                case Enums.AnchorType.Up:
                    this.mvc.view.$().attr({ orientation: 'horizontal' }); break;
                case Enums.AnchorType.Left:
                case Enums.AnchorType.Right:
                    this.mvc.view.$().attr({ orientation: 'vertical' }); break;
                default:
                    this.mvc.view.$().attr({ orientation: 'horizontal' }); break;
            }
        },


        skipFireAllProperty: function (property) {
            if (this._super(property)) {
                return true;
            }

            switch (property) {
                case Enums.ParameterRoles.X:
                case Enums.ParameterRoles.Y:
                    return true;
                default:
                    return false;
            }
        },

        attachEvents: function() {
            this._super();

            this._getIndicator().on('click', function () {
                ErrorsPopup.controller.open();
            });

            this._getCloseButton().on('click', function () {                
                    this._hideTaskBar();                
            }.bind(this));
        },

        _getIndicator: function () {
            return this.mvc.view.$('div.indicator');
        },

        _getCloseButton: function () {
            return this.mvc.view.$('div.close-button');
        },

        _handleOnlineStatus: function () {
            this._getIndicator().addClass(online).removeClass(offline);
            if (this.wasOffline === true) {
            //    this._showTaskBar();
                this.wasOffline = false;
            }
        },

        childModelPropertyChangedInternal: function (event) {
            this._super(event);
            this._showTaskBar();
        },

        _handleOfflineStatus: function () {
            this._getIndicator().addClass(offline).removeClass(online);
            this.wasOffline = true;
            this._showTaskBar();
        },

        _onClientErrorOccured: function (e) {
            this._getIndicator().addClass(clientError);
            ErrorsPopup.controller.addMessage(e.error);
            if (this.mvc.model.getAutoPopUp()) {
                this._showTaskBar();
            }
        },

        _hideTaskBar: function () {
            this.mvc.model.set(Enums.ParameterRoles.IS_VISIBLE, false);
        },
        _showTaskBar: function () {          
            this.mvc.model.set(Enums.ParameterRoles.IS_VISIBLE, true);
        }
    });

    return TaskBarController;
});