﻿define(['common/Enums', 'common/Appearence', 'common/Utilites', 'controls/DateTimePicker/DateTimePickerController'],
 
function (Enums, Appearence, Utilites, DateTimePickerController, Error) {
    var TimePickerController = DateTimePickerController.extend({
        init: function () {
            this._super();
            this.ClassName = 'TimePickerController';
        },
        parseValue: function (value) {
            var time = new Date(value);
            var result = [];
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    case 'H':
                        result.push(time.getUTCHours());
                        break;
                    case 'm':
                        result.push(time.getUTCMinutes());
                        break;
                    case 's':
                        result.push(time.getUTCSeconds());
                        break;
                    case 'f':
                        result.push(time.getUTCMilliseconds());
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            } 
            return result;
        },
        getDateTimeFromArrayVal: function (event) {
            var result = new Date(0);
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    case 'H':
                        result.setUTCHours(event[i]);
                        break;
                    case 'm':
                        result.setUTCMinutes(event[i]);
                        break;
                    case 's':
                        result.setUTCSeconds(event[i]);
                        break;
                    case 'f':
                        result.setUTCMilliseconds(event[i]);
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            }
            return result;
        },
        formatPickerResult: function (event) {
            var result = this.getDateTimeFromArrayVal(event);
            result = new Date(Utilites.timeToUtc(result.getTime()));
            return String.format('{0:' + this.mvc.model.getDateTimeFormat() + '}', result);
        }
    });

    return TimePickerController;
});
