﻿define(['common/Enums', 'base/ObservableObject', 'common/Appearence'], function (Enums, ObservableObject, Appearence) {
    var events = Enums.TrendEvents;

    var Grid = ObservableObject.extend({
        init: function (canvas, size, model) {
            this._super();
            this.canvas = canvas;
            this.size = size;
            this.model = model;
        },

        position: function (xMajorTicks, yMajorTicks, xMinorTicks, yMinorTicks) {
            this.updateGridLinesPosition(xMajorTicks, yMajorTicks, xMinorTicks, yMinorTicks);
            this.eventTarget.fire(events.position);
        },

        draw: function () {
            this.canvas.clearRect({ x: this.x, y: this.y, width: this.width, height: this.height });
            this._drawBackLayer();
            this._drawVerticalLines();
            this._drawHorizontalLines();
        },

        getDimensions: function () {
            return {
                x: this.x,
                y: this.y,
                width: this.width,
                height: this.height
            }
        },

        updateGridLinesPosition: function (xMajorTicks, yMajorTicks, xMinorTicks, yMinorTicks) {
            if (xMajorTicks !== undefined) {
                this.xMajorTicks = xMajorTicks;
            }

            if (xMinorTicks !== undefined) {
                this.xMinorTicks = xMinorTicks;
            }

            if (yMajorTicks !== undefined) {
                this.yMajorTicks = yMajorTicks;
            }

            if (yMinorTicks !== undefined) {
                this.yMinorTicks = yMinorTicks;
            }

            if (this.yMajorTicks === undefined || this.xMajorTicks === undefined ||
                this.yMinorTicks === undefined || this.xMinorTicks === undefined) {
                return;
            }

            if (xMajorTicks.length > 0) {
                var xLen = xMajorTicks.length - 1,
                w = xMajorTicks[xLen][0] - xMajorTicks[0][0];
                this.width = w;
            }

            if (yMajorTicks.length > 0) {
                yLen = yMajorTicks.length - 1,
                x = yMajorTicks[yLen][0],
                y = yMajorTicks[yLen][1],
                h = yMajorTicks[0][1] - yMajorTicks[yLen][1];
                this.height = h;
                this.x = x;
                this.y = y;
            }
        },

        _drawBackLayer: function () {
            var backLayer = {};
            backLayer.fillStyle = Appearence.color.toCssColor(this.model.get(Enums.ParameterRoles.CHART_BACKGROUND));
            backLayer.strokeStyle = Appearence.color.toCssColor(this.model.get(Enums.ParameterRoles.GRID_LINE_STROKE_COLOR));
            backLayer.x = this.x;
            backLayer.y = this.y;
            backLayer.width = this.width;
            backLayer.height = this.height;
            this.canvas.drawRect(backLayer);
            backLayer = null;
        },

        _drawVerticalLines: function () {
            var i;
            //major
            // рисуем линии только для промежуточных меток (без первой и последней)
            var thickness = this.model.get(Enums.ParameterRoles.GRID_LINE_THICKNESS);
            for (i = 1, l = this.xMajorTicks.length - 1; i < l; ++i) {
                this._drawLine(this.xMajorTicks[i][0], this.y, thickness / 2, this.height);
            }

            //minor            
            for (i = 0, l = this.xMinorTicks.length; i < l; i++) {
                this._drawLine(this.xMinorTicks[i][0], this.y, thickness / 4, this.height);
            }
        },

        _drawHorizontalLines: function () {
            // рисуем линии только для промежуточных меток (без первой и последней)
            var thickness = this.model.get(Enums.ParameterRoles.GRID_LINE_THICKNESS);
            var i;

            for (i = 1, l = this.yMajorTicks.length - 1; i < l; ++i) {
                this._drawLine(this.x, this.yMajorTicks[i][1], this.width, thickness / 2);
            }

            for (i = 0, l = this.yMinorTicks.length; i < l; i++) {
                this._drawLine(this.x, this.yMinorTicks[i][1], this.width, thickness / 4);
            }
        },

        _drawLine: function (x, y, w, h) {
            // TODO переделать на линию
            var line = {};
            line.x = x;
            line.y = y;
            line.width = w;
            line.height = h;
            line.fillStyle = Appearence.color.toCssColor(this.model.get(Enums.ParameterRoles.GRID_LINE_FILL_COLOR));
            this.canvas.drawRect(line);
            line = null;
        }
    });

    return Grid;
});