﻿// <copyright file="MiniLegend.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// _completedRequest

define(['common/Enums', 'base/ObservableObject', 'common/Utilites', 'common/Appearence',
    'controls/Trend/modules/models/MiniLegendModel', 'controls/Trend/modules/Alghoritms',
'controls/Trend/modules/HideMiniLegendCircle'],

    function (Enums, ObservableObject, Utilites, Appearence, MiniLegendModel, Alghoritms, HideMiniLegendCircle) {

        var MiniLegend = ObservableObject.extend({

            init: function (canvas, parent, trendModel, graphs, mvcModel) {
                this._super();
                this._parent = parent;
                this.model = new MiniLegendModel(trendModel);
                this.canvas = canvas;
                // scale for miniLegend canvas wigth. it's % from linesCanvas
                this.scaleWidth = 0.95;
                this.canvas.addHitRegion(Enums.EventType.click, this._processCheckBoxClick.bind(this));
                this.rowBoxes = [];
                this.graphs = graphs;
                this.hideMiniLegendCircle = new HideMiniLegendCircle(this.canvas, mvcModel);

                for (var i = 0; i < this.model.getTrendlines().length; i++) {
                    this.rowBoxes.push({
                        checkBox: {
                            coord: null
                        },
                        rowBox: {
                            coord: null
                        }
                    });
                }
            },

            render: function () {
                if (this._parent.mvc.model.get(Enums.ParameterRoles.SHOW_LEGEND)) {
                    this.canvas.beginRender();
                    this.canvas.clear();
                    this.hideMiniLegendCircle.draw();
                    for (var i = 0; i < this.model.getTrendlines().length; i++) {
                        this._renderRow(i);
                    }

                    this.canvas.endRender();
                } else {
                    this.canvas.beginRender();
                    this.canvas.clear();
                    this.hideMiniLegendCircle.draw();
                    this.canvas.endRender();
                }
            },

            update: function () {
                this.render();
            },

            getDimensions: function () {
                
                var scale = (this._parent.linesCanvas.canvas.width <= this._getOverallWidth()) ? this.scaleWidth * this._parent.linesCanvas.canvas.width :
                    this._getOverallWidth();

                return {
                    x: 0,
                    y: 0,
                    width: scale,
                    height: this._getRowHeight() * this.model.getTrendlines().length + this.hideMiniLegendCircle.options.circulRadius * 2
                }
            },

            _getRowHeight: function () {
                return this.canvas.getFontSize() +
                    Math.max(
                        this.model.style.checkbox.padding.top + this.model.style.checkbox.padding.bottom,
                        this.model.style.name.padding.top + this.model.style.name.padding.bottom
                    );
            },

            _renderRow: function (rowNum) {
                var scale = (this._parent.linesCanvas.canvas.width <= this._getOverallWidth()) ? this.scaleWidth * this._parent.linesCanvas.canvas.width :
                    this._getOverallWidth(),
                    w = scale,
                    h = this._getRowHeight(rowNum),
                    y = this._getRowOffsetY(rowNum),
                    selectLine = this.graphs[rowNum],
                    selectLineColor = selectLine.model.isSelected ? selectLine.model.getSelectionColor() : selectLine.model.getLineColor();

                this.canvas.setFillStyle(selectLineColor);
                this.canvas.setStrokeStyle(selectLineColor);
                this.rowBoxes[rowNum].rowBox.coord = {
                    minX: 0,
                    minY: y,
                    maxX: w,
                    maxY: y + h
                };

                this.canvas.drawRect({
                    x: 0,
                    y: y,
                    width: w,
                    height: h,
                    strokeStyle: selectLineColor
                });

                this._renderName(rowNum, this._renderCheckbox(rowNum));
            },

            _renderCheckbox: function (rowNum) {
                var fs = this.canvas.getFontSize(),
                    w = fs,
                    offsetY = this._getRowOffsetY(rowNum),
                    selectLine = this.graphs[rowNum];

                x = this.model.style.checkbox.padding.left,
                y = offsetY + this.model.style.checkbox.padding.top,



                this.rowBoxes[rowNum].checkBox.coord = {
                    minX: x,
                    minY: y,
                    maxX: x + w,
                    maxY: y + w
                };

                this.canvas.drawRect({
                    x: x,
                    y: y,
                    width: w,
                    height: w,
                    strokeStyle: selectLine.model.isSelected ? selectLine.model.getSelectionColor() : selectLine.model.getLineColor()
                });

                if (this.model.getTrendLineVisiblity(rowNum) === true) {
                    this._renderCheckboxRect(rowNum);
                }

                return x + w + this.model.style.checkbox.padding.right;
            },

            _renderCheckboxRect: function (rowNum) {

                var checkBox = this.rowBoxes[rowNum].checkBox.coord,
                    selectLine = this.graphs[rowNum],
                    checkRect = {};

                checkRect.x = checkBox.minX,
                checkRect.y = checkBox.maxY,
                checkRect.width = checkBox.maxX - checkBox.minX,
                checkRect.height = checkBox.minY - checkBox.maxY,
                checkRect.fillStyle = selectLine.model.isSelected ? selectLine.model.getSelectionColor() : selectLine.model.getLineColor()

                this.canvas.drawRect(checkRect);

                checkRect = null;
            },

            _renderName: function (rowNum, x) {
                var fs = this.canvas.getFontSize(),
                    text = this.model.getTrendlineProperty(rowNum, Enums.ParameterRoles.NAME),
                    w = this.canvas.measureText(text),
                    offsetY = this._getRowOffsetY(rowNum);
                x += this.model.style.name.padding.left,
                y = offsetY + this.model.style.name.padding.top + fs;

                this.canvas.fillText({
                    x: x,
                    y: y,
                    text: text,
                    maxWidth: w
                });

                return x + w + this.model.style.name.padding.right;
            },

            _processCheckBoxClick: function (coord) {
                if (!this._parent.mvc.model.get(Enums.ParameterRoles.SHOW_LEGEND)) {
                    return false;
                }

                for (var i = 0; i < this.rowBoxes.length; i++) {
                    var checkBoxCoord = this.rowBoxes[i].checkBox.coord;
                    var rowBoxCoord = this.rowBoxes[i].rowBox.coord;
                    if (Alghoritms.isPointInRegion(coord, {
                        x1: checkBoxCoord.minX,
                        y1: checkBoxCoord.minY,
                        x2: checkBoxCoord.maxX,
                        y2: checkBoxCoord.maxY
                    })) {
                        this.eventTarget.fire({
                            type: Enums.TrendEvents.trendlineVisibility,
                            idx: i,
                            state: !this.model.getTrendLineVisiblity(i)
                        });
                        return true;
                    } else if (Alghoritms.isPointInRegion(coord, {
                            x1: rowBoxCoord.minX,
                            y1: rowBoxCoord.minY,
                            x2: rowBoxCoord.maxX,
                            y2: rowBoxCoord.maxY
                    })) {
                        this.eventTarget.fire({
                            type: Enums.TrendEvents.selectTrendline,
                            idx: i
                        });

                        return true;
                    }
                }

                return false;
            },

            // use zero-based rowNum
            _getRowOffsetY: function (rowNum) {
                return this._getRowHeight() * rowNum + 2 * this.hideMiniLegendCircle.options.circulRadius;
            },

            _getOverallWidth: function () {
                return _.max(this.model.getTrendlines().map(function (line) {
                    return this.canvas.measureText(line.value.Name.value+"    ");
                }, this)) + this.canvas.getFontSize()
                    + this.model.style.checkbox.padding.left
                    + this.model.style.checkbox.padding.right
                    + this.model.style.name.padding.left;
            }

        });


        return MiniLegend;
    });