﻿// <copyright file="VideoController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class VideoController controller class for Video control
*/
define(['common/Enums', 'base/ControlController', 'js!libs/videojs/video.js'],
function (Enums, ControlController) {
    //here we will define controller for button

    var VideoController = ControlController.extend({

        init: function () {
            this._super();

            this.ClassName = 'VideoController';
        },

        onAddedToDOM: function () {
            var video = this.mvc.view.$('video');

            this.videojs = videojs(video[0], {}, function () {
                //do nothing
            });
        },

        onResourceChanged: function (value) {
            //get resource url
            var resourceUrl;
            var source;
            var video;

            if (!value) {
                resourceUrl = null;
            }
            else {
                resourceUrl = this.mvc.model.resourceManager.resolve(value);
            }

            //if some problems - check if type is necessary
            //and if it's needed to change source child
            //instead of src attribute           

            video = this.mvc.view.$('video');

            if (video.attr('src')) {
                this.videojs.pause();
                //remove old source                
                this.mvc.view.$('video').removeAttr('src');
            }

            if (!resourceUrl) {
                return;
            }

            this.mvc.view.$('video').attr('src', resourceUrl);
        },

        applyIsEnabled: function () {
            this._super();

            if (!this.actualEnabled()) {
                this.mvc.view.$('> div').hide();

            } else {
                this.mvc.view.$('> div').show();
            }
        },

        getMixedShadowColor: function () {
            return this.mvc.model.getShadowColor();
        }
    });

    return VideoController;
});