﻿/** 
* @class ResourceManager
* @classdesc Manages type and instance resources.
* Resources are saved in window type.
* There are one instance of resource manager for type
* Resource lookup hierarchy: type=>parent window=>project
*/

define([], function() {

	function ResourceManager(parentManager) {
		// null - это менеджер ресурсов уровня проекта.
		this.parent = parentManager || null;
		this._resources = {};
	};

	ResourceManager.prototype.add = function(id, url) {
		this._resources[id] = url;
	};

	ResourceManager.prototype.getAll = function() {
		return this._resources;
	};

	ResourceManager.prototype.setAll = function(value) {
		this._resources = value;
	};

	ResourceManager.prototype.resolve = function(id) {
		if(this._resources.hasOwnProperty(id)) {
			return this._resources[id];
		}

		var parent = this.parent;
		while(parent !== null) {
			if(parent._resources.hasOwnProperty(id)) {
				return parent._resources[id];
			}

			parent = parent.parent;
		}
	};

	return ResourceManager;

});