﻿// <copyright file="OpenWindowAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/OpenWindowActionBase', 'core/WindowsManager', 'helpers/contextResolver', 'common/Enums'],
    function (OpenWindowActionBase, WindowsManager, contextResolver, Enums) {

        var OpenWindowAction = OpenWindowActionBase.extend({
            init: function (options) {
                this.frame = null;
                this._super(options);
            },

            executeInternal: function (context, resolve, reject, notify) {

                //frame == null - иначе во фрейме текущее окно
                if (this.frame !== null) {
                    return;
                }              

                this._addInputParams();                              

                if (this.constants.Frame != null) {

                    var windowContext = contextResolver.getRootWindow(context);
                    this.frame = contextResolver.resolve(this.constants.Frame, windowContext);
                    var windowModel = WindowsManager.getWindowModelById(this.constants.WindowId, true);

                    this._addInputParams();

                    $.extend(true, windowModel, {
                        parameters: this.replacedModelParameters
                    });

                    this.frame.controller.setWindow(windowModel, true);
                    this._bindProperties();

                    this.frame.controller.updateChildWindowSize();
                    this.frame.model.subscribePropertyChanged(this._onFrameModelPropertyChanged, this);

                    windowModel = null;
                    windowContext = null;
                    this.replacedModelParameters = {};
                    //frame = null;

                } else {
                    if (this.get('OpenNew') == true) {
                        WindowsManager.openWindowInNewTab(this.constants.WindowId);
                    } else {
                        WindowsManager.setActiveWindowModelById(this.constants.WindowId, this.replacedModelParameters);
                    }
                }
               
                resolve();
            },

            _onFrameModelPropertyChanged: function (event) {
                if (event.property === Enums.ParameterRoles.DATA_SOURCE) {
                    this._retrieveOutputPrams();

                    this.frame.model.unsubscribePropertyChanged(this._onFrameModelPropertyChanged);
                    this.frame.model.unsubscribePropertyChanged(this._onWindowPropertyChanged);
                    this.unsubscribePropertyChanged(this._onModelPropertyChanged);

                    this.frame = null;
                    this.parametersChache = {
                        input: {},
                        output: {}
                    };
                }
            },

            getWindow: function () {
                return this.frame.controller.getNestedWindow();
            },
        });


        return OpenWindowAction;
    });