// <copyright file="EventAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['helpers/contextResolver', 'core/adapters/BaseAdapter'], function (contextResolver, BaseAdapter) {

    var EventAdapter = BaseAdapter.extend({
        init: function (settings, type) {
            this._super(settings, type);
            var position = this.settings.path.lastIndexOf('/');
            this.eventId = this.settings.path.substr(position + 1);
            this.elementPath = this.settings.path.substring(0, position);
            this.elementPath = this.elementPath == "" ? "/" : this.elementPath;

            this.propertyPath = settings.propertyPath;
            this.adapterType = "EventAdapter";
        },

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.elementPath, ctx).controller.events[this.eventId];
        }
    });

    return EventAdapter;
});