// <copyright file="SvgAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['core/adapters/BaseAdapter', 'common/Error'], function (BaseAdapter, Error) {
    //     (),
    //  svg-   (svg:Element:class)    
    var SvgAdapter = BaseAdapter.extend({
        svgPrefix: 'svg:',
        init: function (settings, type) {
            this._super(settings, type);
            if (this.propertyPath.indexOf(this.svgPrefix) == -1) {
                Error.onerror('Svg connection does not have svg: prefix. path: {0}, propertyPath: {1}',
                    this.settings.path, this.settings.propertyPath);
            }

            this.adapterType = "SvgAdapter";
        },

        set: function (sender, newProperty, operation, sourceOldProp) {
            var currentProperty = this.get(sender);
            var currentValue = currentProperty!= undefined ? currentProperty.value : undefined;
            var newValue = newProperty != undefined ? newProperty.value : undefined;
            var sourceOldValue = sourceOldProp !== undefined ? sourceOldProp.value : undefined;

            var tokenizedPath = this.propertyPath.split(':');
            if (tokenizedPath.length == 3 && tokenizedPath[2] == 'class') {
                var className = '';
                if (sourceOldValue !== undefined && sourceOldValue !== ''
                    && currentValue !== undefined && currentValue !== '') {
                    var currentClasses = currentValue.split(' ');
                    _.remove(currentClasses, function (name) {
                        return name === sourceOldValue;
                    });

                    className = currentClasses.join(' ');
                } else {
                    className = currentValue;
                }

                if (newValue == undefined || newValue === '') {
                    newValue = className;
                } else if (className != '' && className != undefined) {
                    //prevent class duplicating
                    if (_.indexOf(className.split(' '), newValue) === -1) {
                        newValue = className + ' ' + newValue;
                    } else {
                        newValue = className;
                    }
                }

                newProperty = $.extend(true, {}, newProperty);
                if (newValue != undefined) {
                    newProperty.value = newValue;
                }
            }

            this.getDataSource(sender).setProperty(this.propertyPath, newProperty, false, false);
            currentValue = null;
            newValue = null;
        },
    });

    return SvgAdapter;
});