﻿// <copyright file=PathBuilder.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([], function () {
    var namePartReg = /(\[\d+\]){1}/i,
        arrIndexReg = /\[(\d+)\]/,
        propertyPathSeparator = '.';

    function PathBuilder(path) {
        this.path = path;
        this.pathArray = [];
        if (path) {
            this.pathArray = this.buildArray(this.path);
        }
    };

    PathBuilder.prototype.getArray = function () {
        return this.pathArray;
    }

    PathBuilder.prototype.buildArray = function (path) {
        var pathArray = [];
        if (path === '') {
            return pathArray;
        }

        var pathParts = path.split(propertyPathSeparator),
                    nameParts,
                    arrIndex,
                    i,
                    j,
                    l,
                    k;

        for (i = 0, l = pathParts.length; i < l; ++i) {
            nameParts = _.compact(pathParts[i].split(namePartReg));//Pen, [0]
            for (j = 0, k = nameParts.length; j < k; ++j) {
                //проверяем, что это индекс  + сразу вытягиваем его без скобок []
                arrIndex = nameParts[j].match(arrIndexReg);
                if (arrIndex != null) {
                    pathArray.push(arrIndex[1]);
                } else {
                    pathArray.push(nameParts[j]);
                }
            }
        }

        return pathArray;
    }

    return PathBuilder;
});