/** 
	* @class contextResolver
	* @classdesc Helper used to resolve xpath selectors and returning corresponding MVC object
	
	*/
define([], function () {
    /** 
	* Creates an contextResolver object
	* @constructor
	* @this {contextResolver}
	*/

    function contextResolver() {

    };

    /** 
	* Resolve path relatively to context.
	* @this {contextResolver}
	* @param {string} path Path to control relatively to context.
	* @param {string} context Path to context relatively to root element.
	*/
    contextResolver.prototype.resolve = function (path, context) {
        if (context && context !== null) {
            if (path === '/') {
                return context;
            }

            var pathParts = path.split("/");
            var control = context;
            for (var i = 0, l = pathParts.length; i < l; ++i) {
                if (pathParts[i] !== "") { // /123/456 -> "", "123", "456"
                    control = control.controller.controls[pathParts[i]];
                }
            }

            return control;
        }
    }

    contextResolver.prototype.getParentControl = function (context, controlModelName) {
        if (context && context !== null) {
            var parent = context.mvc._parent;

            if (parent === null || context.mvc.model.ClassName === controlModelName) {
                return context.mvc;
            }

               while (parent !== null && parent._parent!==null && parent.model.getId !== undefined && parent.model.ClassName != controlModelName) {
	            parent = parent._parent;
	        }

	        return parent;
	    }
	}
	contextResolver.prototype.getRootWindow = function (context) {
	    if (context && context !== null) {
	        var parent = context.mvc._parent;

	        while (parent !== null && parent._parent !== null && parent._parent.model.ClassName != "FrameModel") {
	            parent = parent._parent;
	        }

	        return parent;
	    }
	}
	contextResolver.prototype.getParentWindowControl = function (context) {
	    return this.getParentControl(context, "WindowModel");	    
	}

	contextResolver.prototype.getParentDialogControl = function (context) {
	    return this.getParentControl(context, "FrameModel");
	}


	return new contextResolver();
});