﻿// <copyright file="jquery_insat_svg_drawing.js" company="ИнСАТ">
// ИнСАТ, 2013
// </copyright>
// _completedRequest

define(['common/Enums', 'common/Appearence'], function (Enums, Appearence) {

    function SVG() {
        /*
            @method createPattern
                creates pattern element inside given svg, with given Id, with and height
            @param svg - parent svg element
            @param brushId
        */
        //targetID is not used - to be removed after all types of bgs will be modified
        this.createPattern = function (svg, patternId, width, height) {

            var path = $('path', svg.root()).attr('d');
            if (path === undefined || path === '' || path === "") {
                return;
            }
            var bbox = Raphael.pathBBox(path);
            //var patternID = 'pattern' + targetID;
            //patternID = patternID.replace(patternID, patternID + colorID);
            var elementPattern = $('[id ^=' + patternId + ']', svg.root());
            if (elementPattern == undefined || elementPattern.length === 0 || (elementPattern.length == 1 && elementPattern[0] == null)) {
                elementPattern = svg.pattern(patternId, 0, 0, width, height, {
                    viewBox: bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height,
                    overflow: "hidden", patternUnits: 'objectBoundingBox', preserveAspectRatio: 'none'
                });
            } else {
                $(elementPattern).attr('width', width);
                $(elementPattern).attr('height', height);
            }

            return elementPattern;
        };

        this.drawPath = function (id, options, redrawGeometry) {
            var el = $("#" + id);

            if (options.data === undefined || options.data === '' || options.data === "") {
                return;
            }

            var svg = this.getSVG(id);

            var selector = 'path[id="' + id + '"]';

            if (this.isElementExists(selector, svg.root(), svg)) {
                if (redrawGeometry) {
                    svg._svg.innerHTML = '';
                    this.drawPathInternal(id, options, svg, el);
                }
                else {
                    if (options.style.hasOwnProperty('strokeWidth')) {
                        options.style.strokeWidth = parseInt(options.style.strokeWidth, 10) + 'px';
                    }
                    svg.change($(selector, svg.root())[0], options.style);
                }
            } else {
                this.drawPathInternal(id, options, svg, el);
            }


        };

        this.drawPathInternal = function (id, options, svg, element) {
            var containerWidth = element.width();
            var containerHeight = element.height();
            if (options.scaleX != 1 || options.scaleY != 1) {
                options.style.transform = 'scale(' + options.scaleX + ',' + options.scaleY + ')';
            }
            options.style.strokeWidth = parseInt(options.style.strokeWidth, 10) + 'px';
            svg.path(options.data, options.style);
            this.drawRelativePath(id, svg, element);
        };

        this.setGeometryClipPath = function (id, path) {
            var el = $("#" + id);
            var svg = this.getSVG(id);
            var clipId = id + '_clip'
            var selector = 'clippath[id="'+clipId+'"]';
            var pathSelector = 'path[id="' + id + '"]';

            if (this.isElementExists(selector, svg.root(), svg)) {             
                svg.change($(selector, svg.root())[0], {path: path});
            } else {
                var clipPath = svg.clipPath(clipId);
                svg.path(clipPath, path);
                svg.change($(pathSelector, svg.root())[0], { clipPath: 'url(#' + clipId + ')'});
            }
        };


        this.drawRelativePath = function (id, svg, element) {
            var path = $('path', svg.root()).attr('d');
            var bbox = Raphael.pathBBox(path);
            //try to avoid x and y bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height,
            svg.change(svg.root(), {
                position: 'absolute',
                viewBox:  bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height, //0 + ' ' + 0 + ' ' + bbox.width + ' ' + bbox.height,
                preserveAspectRatio: 'none'
            });

            element = null;
        };

        this.drawLine = function (id) {
            var el = $("#" + id); //this.getElement(id);
            var options = el.data('options');
            var heightUnit = options.height.match(/\D+$/);
            var widthUnit = options.width.match(/\D+$/);
            var xUnit = options.x.match(/\D+$/);
            var yUnit = options.y.match(/\D+$/);
            var thicknessUnit = options.style.strokeWidth.match(/\D+$/);
            $.extend(options, { xUnit: xUnit, yUnit: yUnit, heightUnit: heightUnit, widthUnit: widthUnit, thicknessUnit: thicknessUnit });

            var width = parseFloat(options.width.replace(widthUnit, ''));
            var height = parseFloat(options.height.replace(heightUnit, ''));
            var x = parseFloat(options.x.replace(xUnit, ''));
            var y = parseFloat(options.y.replace(yUnit, ''));
            options.style.strokeWidth = options.style.strokeWidth.replace(thicknessUnit, ''); //FF не сделает setAttribute с px
            var thickness = parseFloat(options.style.strokeWidth);
            var shadowOffset = parseFloat(options.shadowSettings.offset);

            var color = options.style.stroke;
            var linestyle = options.linestyle;

            var svg = this.getSVG(id);

            if (widthUnit == 'px' && heightUnit == 'px') {
                var lineCoords = { x1: 0, x2: width, y1: 0, y2: height };
                var absWidth = Math.abs(width);
                var absHeight = Math.abs(height);
                if (absWidth == 0) {
                    absWidth = thickness + shadowOffset;
                }
                if (absHeight == 0) {
                    absHeight = thickness + shadowOffset;
                }

                var newX = x;
                var newY = y;

                if (width <= 0 && height >= 0) {
                    newX = x + width;
                    newY = y;
                    width == 0 ? lineCoords.x1 = 0 : lineCoords.x1 = absWidth;
                    lineCoords.y1 = 0;
                    lineCoords.x2 = 0;
                    lineCoords.y2 = height;
                }
                else if (height <= 0 && width >= 0) {
                    newX = x;
                    newY = y + height;
                    lineCoords.x1 = 0;
                    lineCoords.y1 = absHeight;
                    lineCoords.x2 = width;
                    lineCoords.y2 = 0;
                }
                else if (height <= 0 && width <= 0) {
                    newX = x + width;
                    newY = y + height;
                    lineCoords.x1 = absWidth;
                    height == 0 ? lineCoords.y1 = 0 : lineCoords.y1 = absHeight;
                    lineCoords.x2 = 0;
                    lineCoords.y2 = 0;
                }

                svg.change(svg.root(), { width: absWidth, height: absHeight });
            }
            else if (widthUnit == '%' && heightUnit == '%') {
                var lineCoords = { x1: 0, x2: width, y1: 0, y2: height };
                var absWidth = Math.abs(width);
                var absHeight = Math.abs(height);
                if (absWidth == 0) {
                    absWidth = thickness + shadowOffset;
                }
                if (absHeight == 0) {
                    absHeight = thickness + shadowOffset;
                }

                var newX = x;
                var newY = y;

                if (width <= 0 && height >= 0) {
                    newX = x + width;
                    newY = y;
                    lineCoords.x1 = 0;
                    lineCoords.y1 = '100%';
                    width == 0 ? lineCoords.x2 = 0 : lineCoords.x2 = '100%';
                    lineCoords.y2 = 0;
                }
                else if (height <= 0 && width >= 0) {
                    newX = x;
                    newY = y + height;
                    lineCoords.x1 = 0;
                    height == 0 ? lineCoords.y1 = 0 : lineCoords.y1 = '100%';
                    width == 0 ? lineCoords.x2 = 0 : lineCoords.x2 = '100%';
                    lineCoords.y2 = 0;
                }
                else if (height <= 0 && width <= 0) {
                    newX = x + width;
                    newY = y + height;
                    lineCoords.x1 = 0;
                    lineCoords.y1 = 0;
                    lineCoords.x2 = '100%';
                    lineCoords.y2 = '100%';
                }

                else if (height >= 0 && width >= 0) {
                    newX = x;
                    newY = y;
                    lineCoords.x1 = 0;
                    lineCoords.y1 = 0;
                    lineCoords.x2 = '100%';
                    lineCoords.y2 = '100%';
                }
            }


            if (options.linestyle.toUpperCase() == 'DASHED') {
                var spacing = 5 * thickness;
                options.style.strokeDashArray = [spacing, spacing];
            }
            if (options.linestyle.toUpperCase() == 'DOTTED') {
                spacing = 1.25 * thickness;
                options.style.strokeDashArray = [spacing, spacing];
                options.style.strokeLineCap = 'round';
            }

            if (parseFloat(options.shadowSettings.offset) != 0) {
                this.drawShadow(options, svg, this.getShadowFilterId(id));
                this.setShadowFilterId(options, id);
            }

            this.deleteElements('line', svg.root(), svg);
            svg.line(lineCoords.x1, lineCoords.y1, lineCoords.x2, lineCoords.y2, options.style);
            el.width(absWidth + xUnit);
            el.height(absHeight + yUnit);
            // И снова костыль для Хрома. Хром не рисует линии в полпикселя толщиной. 
            // Они округляются до толщины 0пикс и не рисуются. Это к 8898.
            // Пользуемся тем, что $.width вернет абсолютное значение(в пикселах) нужного измерения.
            var realWidth = el.width(), realHeight = el.height();
            if (realWidth < 1) {
                absWidth *= (1 / realWidth);
            }

            if (realHeight < 1) {
                absHeight *= (1 / realHeight);
            }

            if (widthUnit == '%' && heightUnit == '%') {
                el.css('height', Math.ceil((100 * realHeight / el.parent().height())) + '%');
                el.css('width', Math.ceil((100 * realWidth / el.parent().width())) + '%');
            }
            else {
                el.height(absHeight + yUnit);
                el.width(absWidth + yUnit);
            }

            el.css({ top: newY + yUnit, left: newX + xUnit });
            options = null;
            el = null;
        };

        this.getSVG = function (clientId) {
            var svg = $('#' + clientId).svg('get');
            if (!svg) {
                $('#' + clientId).svg();
                svg = $('#' + clientId).svg('get');
                svg.configure({ position: 'absolute', width: '100%', height: '100%' }, false);
                svg.root().style.position = 'absolute';
                svg.root().style.left = 0;
                svg.root().style.top = 0;
                svg.root().style.overflow = 'visible';
            }

            return svg;
        };


        this.getElement = function (clientId) {
            return $('svg[id="' + clientId + '"]');
        };

        this.getShadowFilterId = function (targetId) {
            return filterID = 'shadow_' + targetId.replace('#', '');
        };

        this.setShadowFilterId = function (options, targetId) {
            options.style.filter = 'url(#' + this.getShadowFilterId(targetId) + ')';
        };

        this.registerImagePattern = function (options) {

            var x = 0,
                y = 0,
                imageWidth = 0,
                imageHeight = 0,
                imagePatternWidth = 0,
                imagePatternHeight = 0,
                svgWidth,
                svgHeigth,
                imagePatternId = options.brushId + '_image',
                imagePattern;

            //calculate size and position of image and image pattern
            if (options.imageTiling === Enums.TileType.Tile) {
                //will setup asynchroniously
            }
            else if (options.imageTiling === Enums.TileType.Fill) {
                imageWidth = '100%';
                imageHeight = '100%';
                imagePatternWidth = '100%'
                imagePatternHeight = '100%';
            }
            else if (options.imageTiling === Enums.TileType.Center || options.imageTiling === Enums.TileType.No) {
                imagePatternWidth = '100%'
                imagePatternHeight = '100%';
                //will setup rest asynchroniously                
            }

            //create patterns

            var elementPattern = this.createPattern(options.svg, options.brushId, '100%', '100%');

            this.removeGeometryImageBg(options.svg);

            var defs = $('defs', elementPattern);
            if (defs.length === 0) {
                defs = options.svg.defs(elementPattern);
            }

            imagePattern = options.svg.pattern(defs, imagePatternId, 0, 0, imagePatternWidth, imagePatternHeight, {
                overflow: "hidden",
                patternUnits: 'userSpaceOnUse',//'objectBoundingBox',
                preserveAspectRatio: 'none'
            });
            $(imagePattern, options.svg.root()).addClass('image-bg-js');

            var image = options.svg.image(imagePattern,
                                x, y,
                                imageWidth,
                                imageHeight,
                                options.imagePath,
                                { preserveAspectRatio: 'none', 'class': 'image-bg-js' });
            $(image, options.svg.root()).addClass('image-bg-js');

            //create internal path with reference to just created image pattern
            var path = options.svg.path(elementPattern, $('path', options.svg.root()).attr('d'),
                {
                    fill: 'url(#' + imagePatternId + ')',
                });
            $(path, options.svg.root()).addClass('image-bg-js');

            switch (options.imageTiling) {
                case Enums.TileType.Tile:
                    configureImagePattern(options.imagePath, image, imagePattern, setupImageTile);
                    break;
                case Enums.TileType.No:
                    configureImagePattern(options.imagePath, image, imagePattern, setupImageTileNo);
                    break;
                case Enums.TileType.Center:
                    configureImagePattern(options.imagePath, image, imagePattern, setupImageCenter);
                    break;
            }         
        };

        function configureImagePattern(imageUrl, image, pattern, callback) {
            var el = new Image();
            el.onload = function () {
                callback(image, pattern, this.width, this.height);
            };

            el.src = imageUrl;
        };

        function setupImageTile(image, pattern, width, height) {
            $(image).attr('width', width).attr('height', height);
            $(pattern).attr('width', width).attr('height', height);
        };

        function setupImageTileNo(image, pattern, width, height) {

            var svg = $(pattern).parents('svg');

            var svgWidth = $(svg).width();
            var svgHeigth = $(svg).height();            

            $(image).attr('x', 0)
                    .attr('y', 0)
                    .attr('width', width)
                    .attr('height', height);
        };


        function setupImageCenter(image, pattern, width, height) {

            var svg = $(pattern).parents('svg');

            var svgWidth = $(svg).width();
            var svgHeigth = $(svg).height();

            var x = (svg[0].viewBox.baseVal.width - width) / 2;
            var y = (svg[0].viewBox.baseVal.height - height) / 2;

            $(image).attr('x', x)
                    .attr('y', y)
                    .attr('width', width)
                    .attr('height', height);
        };

        this.registerSolidBrush = function (options) {
            var width = '100%',
            height = '100%';

            var path = $('path', options.svg.root()).attr('d');

            if (path === undefined || path === '' || path === "") {
                return;
            }

            var elementPattern = this.createPattern(options.svg, options.brushId, width, height);

            this.removeGeometryColorBg(options.svg);

            //set fill color
            var path = options.svg.path(elementPattern, $('path', options.svg.root()).attr('d'),
                {
                    fill: options.color,
                });
            $(path, options.svg.root()).addClass('color-bg-js');

            //bring background color to back
            $(path).prependTo(elementPattern);
        };

        this.registerLinearGradientBrush = function (options) {
            var width = '100%',
                height = '100%';
            var stops = Appearence.svg.toLinearGradientStops(options.colors);
            var gradientId = options.brushId + '_gradient';

            var path = $('path', options.svg.root()).attr('d');
            if (path === undefined || path === '' || path === "") {
                return;
            }

            var elementPattern = this.createPattern(options.svg, options.brushId, width, height);
            this.removeGeometryColorBg(options.svg);

            if (stops === undefined || stops.length < 2) {
                return;
            }

            var start = options.brushCoords.first.split(/\,/);
            var end = options.brushCoords.last.split(/\,/);

            var defs = $('defs', elementPattern);
            if (defs.length === 0) {
                defs = options.svg.defs(elementPattern);
            }
            //create gradient with id
            var gradient = options.svg.linearGradient(defs,
                                       gradientId,
                                       stops,
                                       start[0], start[1],
                                       end[0], end[1],
                                       { gradientUnits: 'objectBoundingBox' });
            $(gradient, options.svg.root()).addClass('color-bg-js');

            //create internal path with reference to gradient
            var path = options.svg.path(elementPattern, $('path', options.svg.root()).attr('d'),
                {
                    fill: 'url(#' + gradientId + ')'
                });
            //bring background color to back
            $(path).prependTo(elementPattern);

            $(path, options.svg.root()).addClass('color-bg-js');
        };

        this.registerRadialGradientBrush = function (options) {

            var width = '100%',
            height = '100%';
            var stops = Appearence.svg.toGradientStops(options.colors);
            var gradientId = options.brushId + '_gradient';

            var path = $('path', options.svg.root()).attr('d');
            if (path === undefined || path === '' || path === "") {
                return;
            }

            var elementPattern = this.createPattern(options.svg, options.brushId, width, height);
            this.removeGeometryColorBg(options.svg);

            var defs = $('defs', elementPattern);
            if (defs.length === 0) {
                defs = options.svg.defs(elementPattern);
            }
            //create gradient with id
            var gradient = options.svg.radialGradient(defs,
                                       gradientId,
                                       stops,
                                       options.brushCoords.cx, options.brushCoords.cy,
                                       options.brushCoords.rx,
                                       options.brushCoords.fx, options.brushCoords.fy,
                                       {
                                           gradientUnits: 'objectBoundingBox'
                                       });
            $(gradient, options.svg.root()).addClass('color-bg-js');
            //create internal path with reference to gradient
            var path = options.svg.path(elementPattern, $('path', options.svg.root()).attr('d'),
                {
                    fill: 'url(#' + gradientId + ')',
                    'class': 'color-bg-js'
                });

            $(path, options.svg.root()).addClass('color-bg-js');

            //bring background color to back
            $(path, options.svg.root()).prependTo(elementPattern);
        };

        this.removeGeometryColorBg = function (svg) {
            //this.deleteElements('.color-bg-js', svg.root(), svg);
            $('.color-bg-js', svg.root()).remove();
        };

        this.removeGeometryImageBg = function (svg) {
            //this.deleteElements('.image-bg-js', svg.root(), svg);
            $('.image-bg-js', svg.root()).remove();
        };

        //TODO: to be removed because is not used
        this.registerBrush = function (svg, colorsString) {
            var colors = this.getBrushDirection(colorsString[0], 'svg');
            var colorsArray = $.getGradientColors(colorsString.slice(1, colorsString.length), 'svg');
            var colorID = 'linear_gradient';

            for (var i = 0; i < colorsArray.length; ++i) {
                colorID += '_' + colorsArray[i][1];
            }

            var defsArray = $('defs[id = "defs_' + colorID + '"]', svg.root());
            if (defsArray.length == 0) {
                var defs = svg.defs('defs_' + colorID);
                svg.linearGradient(defs, colorID, colorsArray, colors[0].split(',')[0], colors[0].split(',')[1], colors[1].split(',')[0], colors[1].split(',')[1], { gradientUnits: 'userSpaceOnUse' });
            }

            return 'url(#' + colorID + ')';
        };

        //TODO: to be removed because is not used
        this.purifyColorId = function (color) {
            return color.replace('#', '_').replace('(', '').replace(',', '_').replace(')', '');
        };

        //TODO: to be removed because is not used
        // returns an object contains colorId and colorsArray
        this.getColor = function (colorsString) {
            var colorID = '';
            var colorsArray;
            if (colorsString != '' && colorsString != undefined) {
                colorsArray = $.getGradientColors(colorsString, 'svg');
                var tmpColors = colorsString.split(/\,/);
                for (var i = 0; i < tmpColors.length; ++i) {
                    colorID += this.purifyColorId(tmpColors[i]);
                }
            }

            tmpColors = null;
            return { colorID: colorID, colorsArray: colorsArray };
        };


        this.drawShadow = function (options, svg, filterID) {
            var offset = parseFloat(options.shadowSettings.offset);
            this.deleteElements('filter', svg.root(), svg);
            var shadowColor = options.shadowSettings.color;
            var colorsArray = [parseInt(shadowColor.substring(1, 3), 16), parseInt(shadowColor.substring(3, 5), 16), parseInt(shadowColor.substring(5, 7), 16)];
            var filter = svg.filter(filterID, '0', '0', '100%', '100%', { filterUnits: 'userSpaceOnUse', primitiveUnits: 'userSpaceOnUse' });
            svg.filters.componentTransfer(filter, '', [['discrete', [colorsArray[0]]],
                                            ['discrete', [colorsArray[1]]],
                                            ['discrete', [colorsArray[2]]]]);
            svg.filters.gaussianBlur(filter, '', '', 2);
            svg.filters.offset(filter, 'offsetBlur', '', offset, offset);
            svg.filters.composite(filter, '', 'over', 'SourceGraphic', 'offsetBlur');
            offset = null;
        };

        // root - jQuery object, pointing at SVG
        var findPath = function (root) {
            return $('> path', root);
        }

        this.drawShadowForGeometry = function (id, options) {
            var svg = this.getSVG(id);
            var divContainer = $("#" + id);
            var shadowSvg = divContainer.children("#" + id + 'shadow');
            var offset = parseFloat(options.offset);
            var top = offset;//100 * offset / divContainer.height();
            var left = offset;//100 * offset / divContainer.width();

            var shadowColor = options.color;
            var opacity = options.fillOpacity;
            var colorObj;

            if (Appearence.color.isARGB(shadowColor)) {
                colorObj = Appearence.color.ARGBtoObj(options.color);
                shadowColor = Appearence.color.objToRGB(colorObj);
                opacity = colorObj.a / 255;
            }

            //при первом вызове создаем элемент тени
            if (shadowSvg.length == 0) {
                var svgElement = divContainer.children('svg');

                shadowSvg = svgElement.clone();
                //remove pattern (background) in case if we are adding shadow after geometry was fully created
                //shadowSvg.remove('pattern');

                shadowSvg.prependTo(divContainer);

                shadowSvg.css({
                    position: 'absolute',
                    top: top + 'px',
                    left: left + 'px'
                });
                shadowSvg.attr('id', id + 'shadow');
                shadowSvg.svg();
                shadowSvg = shadowSvg.svg('get');

                var pattern = $('> pattern', shadowSvg.root());
                shadowSvg.change(pattern[0], {
                    id: pattern.attr('id') + "shadow"
                });

                var path = findPath(shadowSvg.root());
                shadowSvg.change(path[0], {
                    id: path.attr('id') + "shadow",
                    fill: shadowColor,
                    fillOpacity: opacity,
                    //opacity: opacity,
                    filter: "url(#" + id + "shadowFilter)",
                    stroke: options.strokeColor,
                    strokeWidth: this.getStrokeWidth(options.strokeWidth)
                });
                var filter = shadowSvg.filter(id + "shadowFilter", '0', '0', '100%', '100%');
                shadowSvg.filters.gaussianBlur(filter, '', '', 0.05);
            }
            else {
                shadowSvg.css({
                    top: top + 'px',
                    left: left + 'px'
                });
                shadowSvg = shadowSvg.svg('get');
                var path = findPath(shadowSvg.root());
                shadowSvg.change(path[0], {
                    fill: shadowColor,
                    fillOpacity: opacity,
                    stroke: options.strokeColor,
                    strokeWidth: this.getStrokeWidth(options.strokeWidth)
                });
            }
        };

        this.getStrokeWidth =  function(strokeWidth){
            return parseInt(strokeWidth, 10) + 'px';
        }

        this.removeGeometryShadow = function (id) {
            var divContainer = $("#" + id);
            divContainer.children("#" + id + 'shadow').remove();
        };

        this.getBrushDirection = function (direction, elementType) {
            var result = new Array();
            direction = direction.replace('Gradient', '');
            if (elementType == 'svg') {
                if (direction == 'Bottom') {
                    result[1] = "50%,0%";
                    result[0] = "50%,100%";
                }
                else if (direction == 'BottomLeft') {
                    result[0] = "0%,0%";
                    result[1] = "100%,100%";
                }
                else if (direction == 'BottomRight') {
                    result[0] = "100%,100%";
                    result[1] = "100%,0%";
                }
                else if (direction == 'Left') {
                    result[0] = "0%,50%";
                    result[1] = "50%,100%";
                }
                else if (direction == 'Right') {
                    result[0] = "100%,50%";
                    result[1] = "0%,50%";
                }
                else if (direction == 'Top') {
                    result[1] = "50%,100%";
                    result[0] = "50%,0%";
                }
                else if (direction == 'TopLeft') {
                    result[0] = "0%,0%";
                    result[1] = "100%,100%";
                }
                else if (direction == 'TopRight') {
                    result[0] = "100%,0%";
                    result[1] = "0%,100%";
                }
                else {
                    result[0] = "0%,50%";
                    result[1] = "50%,100%";
                }
            }
            else if (elementType == 'linear') {
                if (direction == 'Bottom') {
                    result[0] = "bottom";
                }
                else if (direction == 'Left') {
                    result[0] = "left";
                }
                else if (direction == 'Right') {
                    result[0] = 'right';
                }
                else if (direction == 'Top') {
                    result[0] = "top";
                }
            }
            return result;
        };

        this.deleteElements = function (selector, context, svg) {
            var elements = $(context).children(selector);
            if (elements.length > 0) {
                for (var i = 0, l = elements.length; i < l; ++i) {
                    svg.remove(elements[i]);
                }
            }
        };

        this.isElementExists = function (selector, context, svg) {
            var elements = $(context).children(selector);
            if (elements.length > 0) {
                return true;
            } else {
                return false;
            }
        };

        this.changeBbox = function (svg, width, height) {
            //var svg = this.getSVG(id);
            var path = $('path', svg.root()).attr('d');
            var bbox = Raphael.pathBBox(path);
            svg.change(svg.root(), {
                position: 'absolute', width: '100%', height: '100%', x: '0', y: '0',
                viewBox: bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height,
                preserveAspectRatio: 'none'
            });
        };
    };

    (function ($) {
        var methods = {
            set: function (borderStyle) {
                if (borderStyle === BorderStyle.solid) {
                    return;
                }

                var bw = $(this).data('options').style.strokeWidth.replace($(this).data('options').style.strokeWidth.match(/\D+$/), '');
                switch (borderStyle) {
                    case BorderStyle.dashed:
                        {
                            $(this).data('options').style.strokeDashArray = '' + 5 * bw + ',' + 5 * bw;
                            break;
                        }
                    case BorderStyle.dotted:
                        {
                            $(this).data('options').style.strokeDashArray = '' + 1 * bw + ',' + 2 * bw;
                            break;
                        }
                }
            },
            get: function () {
                var array = $(this).data('options').style.strokeDashArray;
                if (array == '' || array == undefined) {
                    return BorderStyle.solid;
                }
                var number = parseFloat(array.split(',')[1]) / parseFloat(array.split(',')[0]);
                if (number == 2) {
                    return BorderStyle.dashed;
                }
                else if (number == 1) {
                    return BorderStyle.dotted;
                }
                else {
                    return BorderStyle.solid;
                }
            }
        };

        $.fn.dashes = function (method) {
            // Method calling logic
            if (methods[method]) {
                return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
            } else {
                $.error('Method ' + method + ' does not exist on jQuery.dashes');
            }
        };
    }(jQuery));

    function getStringUnits(value) {
        try {
            var number = value.match(new RegExp("([\\s-\\d\\.]+)(?:%|px|mm|inch|em|cm)"))[0]; //left:\\s*([\\d\\.]+(?:%|px|mm|inch|em|cm))/
            var unit = number.match(/\D+$/);  // get the existing unit
            unit = (unit == null) ? 'px' : unit[0]; // if its not set, assume px - otherwise grab string
            return unit;
        } catch (err) {
            return '%';
        }
    }


    var _svgApi = new SVG();

    return _svgApi;
});