﻿// <copyright file="EventsAdapter.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['server/Server', 'when', 'common/Utilites', 'common/Enums',
'server/adapters/DataAdapterErrorProcessor', 'server/adapters/DataAdapter'],
function (server, when, utils, Enums, DataAdapterErrorProcessor, DataAdapter) {

    var EventsAdapter = DataAdapter.extend({

        addMonitoredEvents: function (items) {
            items.forEach(function (item) {
                item.taskId = this.sGet(this.stateVars.taskId);
                item.itemId = this.sGet(this.stateVars.itemId);
                item.path = this.sGet(this.stateVars.path);
            }, this);

            var query = {
                subscriptionId: this.sGet(this.stateVars.SubscriptionId),
                items: items
            };

            return this.sendQuery(Enums.queryType.createMonitoredEvents, query);
        },

        getAll: function () {
            var query = {
                subscriptionId: this.sGet(this.stateVars.SubscriptionId),
                ackSequenceNumber: this.sGet(this.stateVars.ackSequenceNumber)
            };

            var ctx = this;
            return this.sendQuery(Enums.queryType.publishEvents, query).then(function (result) {
                if (result.data.subscriptionId == ctx.sGet(ctx.stateVars.SubscriptionId) && result.data.sequenceNumber && result.data.sequenceNumber > ctx.sGet(ctx.stateVars.ackSequenceNumber)) {
                    ctx.sSet(ctx.stateVars.ackSequenceNumber, result.data.sequenceNumber);
                }

                return {
                    recs: result.data.recs || [],
                    fields: result.data.fields || [],
                    deleted: result.data.deleted || [],
                    serverTime: result.data.serverTime
                };
            });
        },

        createDataSubscription: function () {
            var query = {
                requestedPublishingInterval: this.sGet(this.stateVars.requestedPublishingInterval),
                requestedLifetimeInterval: 300000, //this.sGet(this.stateVars.requestedLifetimeInterval),
                maxNotificationsPerPublish: this.sGet(this.stateVars.maxNotificationsPerPublish),
                maxSize: this.sGet(this.stateVars.maxSize)
            }

            var ctx = this;
            return this.sendQuery(Enums.queryType.createEventSubscription, query).then(function (result) {
                ctx.sSet(ctx.stateVars.SubscriptionId, result.data.subscriptionId);
                ctx.sSet(ctx.stateVars.requestedPublishingInterval, result.data.revisedPublishingInterval);
                ctx.sSet(ctx.stateVars.requestedLifetimeInterval, result.data.revisedLifetimeInterval);
                ctx.sSet(ctx.stateVars.Connected, true);
            });

        },

        refresh: function () {
            var query = {
                subscriptionId: this.sGet(this.stateVars.SubscriptionId),
            };

            return this.sendQuery(Enums.queryType.refreshEvents, query);
        },

        destroy: function () {
            if (this.sGet(this.stateVars.SubscriptionId) !== -1) {

                var query = {
                    subscriptionId: this.sGet(this.stateVars.SubscriptionId)
                }

                //проставляем удаление без ожидания ответа
                //т.к нет никакой необходимости ожидать возрат запроса            
                this.sSet(this.stateVars.ackSequenceNumber, 0);
                this.sSet(this.stateVars.SubscriptionId, -1, true);
                return this.sendQuery(Enums.queryType.deleteEventSubscription, query);
            }

            return when.resolve();
        },

        acknowledgeEvents: function (events) {
            var ackEvents = {
                subscriptionId: this.sGet(this.stateVars.SubscriptionId),
                recs: events
            };

            return this.sendQuery('AcknowledgeEvents', ackEvents);
        },

        deleteMonitoredEvent: function (monitoredItemId) {
            var query = {
                subscriptionId: this.sGet(this.stateVars.SubscriptionId),
                items: [monitoredItemId]
            };

            return this.sendQuery(Enums.queryType.deleteMonitoredEvents, query);
        },

        getArchiveData: function (params) {
            var query = $.extend({
                startTime: 0,
                endTime: 0,
                maxRecs: this.sGet(this.stateVars.maxSize),
                maxSize: 0,
                taskId: this.sGet(this.stateVars.taskId),
                itemId: this.sGet(this.stateVars.itemId),
                path: this.sGet(this.stateVars.path),
                fields: [],
                filter: []
            }, params);

            return this.sendQuery(Enums.queryType.getArchivedEvents, query).then(function (result) {
                return result.data;
            });
        }
    });

    return EventsAdapter;
});