﻿// <copyright file="VariablesSource.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'server/sources/VariablesSource', 'server/VariablesManagersHandler'],
    function (Enums, VariablesSource, VariablesManagersHandler) {
        var SCHEME = 'Scheme';

        var SchemeVariablesSource = VariablesSource.extend({
            dataSourceKey: 'dataSourceId',
            getValuesKey: 'getValues',
            setValuesKey: 'setValues',
            init: function () {
                this._super(SCHEME);               
            },           

            _createVM: function (id) {
                return VariablesManagersHandler.get(id, this.ownerId, Enums.variablesManagersSubTypes.scheme);
            }
        });

        var instance = new SchemeVariablesSource();

        return instance;
    });