﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/KnownGeometryProcessor',
'common/GeometryNormalizer/Processor/CustomGeometryProcessor'],
    function (Enums, Error, KnownGeometryProcessor, CustomGeometryProcessor) {

        var GeometryNormalizer = Class.extend({

            normalize: function (geometryPath, width, height, parentWidth, parentHeight) {
                if (geometryPath && geometryPath != '') {
                    if (KnownGeometryProcessor.isKnownGeometry(geometryPath)) {
                        geometryPath = KnownGeometryProcessor.process(geometryPath, width, height);
                    } else {
                        geometryPath = CustomGeometryProcessor.process(geometryPath, width, height, parentWidth, parentHeight);
                    }
                } else {
                    Error.warn('Cannot normalize empty geometry: ' + geometryPath);
                }

                return geometryPath;
            }
        });

        return new GeometryNormalizer();
    });
