﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/PathCommands/PathSyntaxCommand',
    'common/GeometryNormalizer/Processor/PathSyntaxCommandElement'],
    function (Enums, Error, PathSyntaxCommand, PathSyntaxCommandElement) {
        var LineToCommand = PathSyntaxCommand.extend({

        parse: function (args) {
            var tempArray = this._splitPath(args),
                i,
                argsCount = this. _getArgsCount();
            for (i = 0; i < tempArray.length - (argsCount - 1); i += argsCount) {
                var x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i] );
                var y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y, tempArray[i + 1]);

                this.elements.push(x);
                this.elements.push(y);
            }
        },

        getPattern: function() {
            return ' {0},{1} ';
        },

        getCommand: function() {
            return Enums.pathCommand.L;
        }      
    });

    return LineToCommand;
});