﻿define(['common/Enums', 'common/Error', 'common/Utilites',
'common/GeometryNormalizer/Processor/PathCommands/VerticalLineCommand',
'common/GeometryNormalizer/Processor/PathCommands/HorizontalLineCommand',
'common/GeometryNormalizer/Processor/PathCommands/ArcCommand',
'common/GeometryNormalizer/Processor/PathCommands/MoveToCommand',
'common/GeometryNormalizer/Processor/PathCommands/LineToCommand',
'common/GeometryNormalizer/Processor/PathCommands/BezierCurves/CubicBezierCurveCommand',
'common/GeometryNormalizer/Processor/PathCommands/BezierCurves/SmoothBezierCurveCommand',
'common/GeometryNormalizer/Processor/PathCommands/BezierCurves/QuadraticBezierCurveCommand',
'common/GeometryNormalizer/Processor/PathCommands/BezierCurves/SmoothQuadraticBezierCurveCommand',
'common/GeometryNormalizer/Processor/PathCommands/ClosePathCommand'
], function (Enums, Error, Utilites,  VerticalLineCommand, HorizontalLineCommand, ArcCommand, MoveToCommand,
    LineToCommand, CubicBezierCurveCommand, SmoothBezierCurveCommand, QuadraticBezierCurveCommand,
    SmoothQuadraticBezierCurveCommand, ClosePathCommand) {

    function PathSyntaxCommand() {
    }

    PathSyntaxCommand.prototype.create = function (command) {
        if (command.length > 1) {
            Error.onerror("Command must be 1 character length");
        }

        var type = Utilites.isLowerCase(command[0]) ? Enums.pathCommandType.Relative : Enums.pathCommandType.Absolute;
        switch (command.toUpperCase()) {
            case Enums.pathCommand.V:
                return new VerticalLineCommand(type);
            case Enums.pathCommand.H:
                return new HorizontalLineCommand(type);
            case Enums.pathCommand.A:
                return new ArcCommand(type);
            case Enums.pathCommand.M:
                return new MoveToCommand(type);
            case Enums.pathCommand.L:
                return new LineToCommand(type);
            case Enums.pathCommand.C:
                return new CubicBezierCurveCommand(type);
            case Enums.pathCommand.S:
                return new SmoothBezierCurveCommand(type);
            case Enums.pathCommand.Q:
                return new QuadraticBezierCurveCommand(type);
            case Enums.pathCommand.T:
                return new SmoothQuadraticBezierCurveCommand(type);
            case Enums.pathCommand.Z:
                return new ClosePathCommand(type);
            default:
                Error.onerror("Unknown command " + command);
                break;
        }
    }   

    return new PathSyntaxCommand();
});