﻿// <copyright file="CustomSvgModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>

/*
* @class CustomSvgModel model class for CustomSvg control
*/
define(['common/Enums', 'base/ControlModel'],
function (Enums, ControlModel) {
    return ControlModel.extend({
        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.ClassName = 'CustomSvgModel';
        },

        getPropertyType: function (arg) {
            if (arg.indexOf("svg:") === 0) {
                return Enums.serverType.auto;
            }         

            return this._super(arg);
        },

        _getProperty: function (arg, isCopy, shouldExists) {
            if (arg.indexOf("svg:") === 0) {
                return this._super(arg, isCopy, false);
            }

            return this._super(arg, isCopy, shouldExists);
        }
    });
});
