﻿// <copyright file="ThTemplate.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Appearence'],
    function (Enums, Appearence) {
        var ThTemplate = function (that, column) {

            return $$({
                _model: column,
                currentSortOrder: Enums.SortType.No,
                view: {
                    format: '<th><div data-bind="name,title=name"></div></th>'
                },
                _controller: {
                    'click &': function () {
                        if (!that.isEnabled || this._model.get('sortDisabled')) {
                            return;
                        }
                        switch (this.currentSortOrder) {
                            case Enums.SortType.No:
                                this.currentSortOrder = Enums.SortType.Desc;
                                break;
                            case Enums.SortType.Desc:
                                this.currentSortOrder = Enums.SortType.Asc;
                                break;
                            case Enums.SortType.Asc:
                                this.currentSortOrder = Enums.SortType.No;
                                break;
                        }
                        this.setAsSortColumn(this.currentSortOrder);

                        that.updateViewPort();
                        that._onSortOrderChanged();
                    }
                },

                setAsSortColumn: function (sortOrder) {
                    if (this.parent()
                           .selectedHeader !== null) {
                        this.parent()
                            .selectedHeader.view.$()
                            .removeClass("No Desc Asc");
                    }

                    this.view.$()
                           .addClass(this._getSortStyleClassName(sortOrder));
                    that.currentSortField = this._model.get('field');
                    that.currentSortOrder = sortOrder;
                    this.parent()
                        .selectedHeader = this;
                },

                updateStyle: function (columnsStyle) {
                    if (columnsStyle.type == 'px') {
                        this.view.$('div')
                            .css('width', columnsStyle.width);
                    }
                    this.view.$()
                        .css('width', columnsStyle.width);
                    this.view.$()
                        .css('display', columnsStyle.display);
                    this.view.$()
                     .css('text-align', Appearence.text.getTextHAlign(columnsStyle.align));
                },

                _getSortStyleClassName: function (sortType) {
                    if (this.styleCache) {
                        return this.styleCache[sortType];
                    }

                    this.styleCache = {};
                    var type;
                    for (type in Enums.SortType) {
                        this.styleCache[Enums.SortType[type]] = type;
                    }

                    return this.styleCache[sortType];
                }
            });
        }

        return ThTemplate;
    });