﻿// <copyright file="OpenWindowActionBase.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/Action', 'common/Enums', 'core/WindowsManager', 'helpers/PermissionChecker', 'core/L10n', 'helpers/contextResolver'],
    function (Action, Enums, WindowsManager, PermissionChecker, L10n, contextResolver) {

    var ControlFactory;
    var OpenDialogFrameControl;

    //broke cirle dependencies
    curl(['controls/ControlFactory'], function (cf) {
        ControlFactory = cf;
    });

    curl(['core/actions/OpenDialog/OpenDialogFrameControl'], function (cf) {
        OpenDialogFrameControl = cf;
    });

    var OpenWindowActionBase = Action.extend({
        init: function (options) {
            this._super(options);

            this.openedWindows = {};
            this.replacedModelParameters = {};

            this.parametersChache = {
                input: {},
                output: {}
            };
        },

        executeInternal: function (context, resolve, reject, notify) {

        },


        askConfirmation: function (context, resolve, that) {

            var dialogContainer = new OpenDialogFrameControl(context.mvc.model.resourceManager);
            var result = PermissionChecker.createResultObj(that.allowAct, that.denyAct, false);
            var permContext;
            that.dialogContainer = dialogContainer;
            var windowModelOriginal = WindowsManager.getWindowModelById(that.constants.WindowId);
            if (that.type == "OpenDialog") {
                dialogContainer._parent = contextResolver.getRootWindow(context);
                $.extend(dialogContainer.model._data, that._data);
                var windowModel = {};
                that._addInputParams();
                //не портим оригинальную модель
                that.replacedModelParameters[Enums.ParameterRoles.X] = windowModelOriginal.parameters[Enums.ParameterRoles.X];
                that.replacedModelParameters[Enums.ParameterRoles.Y] = windowModelOriginal.parameters[Enums.ParameterRoles.Y];
                that.replacedModelParameters[Enums.ParameterRoles.WIDTH] = windowModelOriginal.parameters[Enums.ParameterRoles.WIDTH];
                that.replacedModelParameters[Enums.ParameterRoles.HEIGHT] = windowModelOriginal.parameters[Enums.ParameterRoles.HEIGHT];
                $.extend(true, windowModel, windowModelOriginal, {
                    parameters: that.replacedModelParameters
                });
                if (that.constants.objectId !== undefined && that.constants.objectId !== 0) {
                    windowModel.objectId = that.constants.objectId;
                    windowModel.serverTaskId = that.constants.serverTaskId;
                }

                var ctx = dialogContainer.controller;
                ctx.setWindow(windowModel, true);
                permContext = dialogContainer.controller.controls[that.constants.WindowId];
            }
            if (that.type == "OpenWindow") {
                permContext = dialogContainer.controller.getPermissionsContext(windowModelOriginal);
                that.dialogContainer = null;
            }
            this.check(result, permContext.controller, context, resolve, that);
            if (result.writelog && !result.confirmation) PermissionChecker.reportAction(context, that.type, false);
        },

        check: function (result, ctx, context, resolve, that) {
            var args = {};
            args.context = context;
            args.resolve = resolve;
            args.that = that;
            var requiredContext = _.isEmpty(ctx.mvc.model.permissions) ? context : ctx;
            if (PermissionChecker.needCheck()) {
                PermissionChecker.check("OpenWindow", requiredContext, result, args);
            } else {
                result.allow_action(args); //если пользователей нет, то считается что всё можно
            }
        },

        getWindow: function () {
            return null;
        },

            _addInputParams: function () {
                var ctx = this;
                _.forEach(this.constants.inputParameters, function (parameter) {
                    ctx.replacedModelParameters[parameter.name] = ctx.getProperty(parameter.name);
                });
            },

        _bindProperties: function (windowObject) {
            this._cacheParams();
            this.getWindow().model.subscribePropertyChanged(this._onWindowPropertyChanged, this);
            this.subscribePropertyChanged(this._onModelPropertyChanged, this);
        },

        _onWindowPropertyChanged: function (event) {
            //если параметр выходной и по изменению
            if (this.parametersChache.output[event.property]) {
                this.setProperty(event.property, this.getWindow().model.getProperty(event.property));
            }
        },

        _onModelPropertyChanged: function (event) {
            if (this.parametersChache.input[event.property]) {
                this.getWindow().model.setProperty(event.property, this.getProperty(event.property));
            }
        },

            _retrieveOutputPrams: function () {
                var ctx = this;
                _.forEach(this.constants.outputParameters, function (parameter) {
                    ctx.setProperty(parameter.name, ctx.getWindow().model.getProperty(parameter.name));
                });
            },

        addReplacedParameter: function (parameters) {
            $.extend(true, this.replacedModelParameters, parameters);
        },

        _cacheParams: function () {
            var ctx = this;
            _.forEach(this.constants.inputParameters, function (parameter) {
                    ctx.parametersChache.input[parameter.name] = parameter.update;
                });
            _.forEach(this.constants.outputParameters, function (parameter) {
                    ctx.parametersChache.output[parameter.name] = parameter.update;
                });
        },

        checkPermissions: function () {

        },

        allowAct: function () {

        },

        denyAct: function () {

        }

    });


    return OpenWindowActionBase;
});
