﻿// <copyright file="LineController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class LineController controller class for Line control
*/

define(['common/Error', 'common/Enums', 'core/connection/ProjectConnections', 'controls/Types'],
function (Error, Enums, ProjectConnections, Types) {
    var ParameterConnections = Class.extend({

        init: function () {
        },

        process: function (parameterName, parameter, control) {
            var conns = this._processInternal(parameterName, parameter, control);
            return conns;
        },

        _processInternal: function (parameterName, parameter, control) {
            var type = Types[parameter.typeName];

            switch (type.type) {
                case Enums.type.object:
                    return this._processObjectParam(parameterName, parameter, control);
                case Enums.type.array:
                    return this._processArrayParam(parameterName, parameter, control);
                default:
                    return this._processParam(parameterName, parameter, control);
            }
        },

        _processObjectParam: function (parameterName, parameter, control) {
            var type = Types[parameter.typeName];
            var conns = []

            if (!parameter.value) {
                return conns;
            }

            var fullPath = parameterName + '.';
            for (var typeMember in type.description) {
                if (parameter.value[typeMember])
                    conns.push.apply(conns,
                        this._processInternal(fullPath + typeMember, parameter.value[typeMember], control));
                else
                    Error.warn("У контрола с id " +
                        control.model.getId() +
                        " не хватает в структуре " +
                        parameterName +
                        " поля " +
                        typeMember +
                        " в соответствии с типом");
            }                      

            return conns;
        },

        _processArrayParam: function (parameterName, parameter, control) {
            var type = Types[parameter.typeName],
                dimensions = type.description.dimensions;
            if (parameter.value.length === 0) {
                return [];
            }

            return this._processArrayDimension(parameterName, parameter, 0, dimensions, control);

        },

        //arrayItemType - имя элемента массива
        _processArrayDimension: function (parameterName, parameter, curr, dimensions, control) {

            var dimension = dimensions[curr], //[startIndex, length]              
                startIndex = 0, //пока наполняем без учета старта dimensions[0],
                length = dimension[1],
                arr = [],
                nextRange = curr + 1,
                i;
                  
         
            for (i = startIndex; i < parameter.value.length; i++) {
                var fullPath = parameterName + '[' + i + ']';
                //если самая глубокая ось (т.е последняя)
                if (curr === dimensions.length - 1) {
                    arr.push.apply(arr, this._processInternal(fullPath, parameter.value[i], control));
                } else {                
                    arr.push.apply(arr, this._processArrayDimension(fullPath, parameter[i], nextRange, dimensions, control));
                }
            }

            return arr;
        },

        _processParam: function (parameterName, parameter, control) {
            var conns = [];
            parameter.connections.forEach(function (connId) {
                conns.push(this._getConnection(parameterName, connId, control));
            }, this);

            return conns;
        },


        _getConnection: function (parameterName, connectionId, control) {
            var connectionSettings = ProjectConnections[connectionId];
            if (!connectionSettings) {
                Error.warn('Connection not found: ' + connectionId);
                return null;
            }

            var newConnSettings = $.extend(true, {}, connectionSettings);
            newConnSettings.source = this._updateEndpointSettings(parameterName, newConnSettings.source, control);
            newConnSettings.target = this._updateEndpointSettings(parameterName, newConnSettings.target, control);

            return newConnSettings;            
        },

        _updateEndpointSettings: function (parameterName, endpoint, control) {
            switch (endpoint.type) {
                case Enums.connectionType.server:
                    endpoint.path = control.controller.buildPath();
                    break;
                case Enums.connectionType.client:
                case Enums.connectionType.svg:
                    endpoint.path = control.controller.buildPath();
                    endpoint.propertyPath = parameterName;
                    break;
                default:
                    Error.warn('Not supported endpoint type ' + endpoint.type);
            }

            return endpoint;
        }

    });

    var instance = new ParameterConnections();
    return instance;
});