﻿// <copyright file=XhrWrapper.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([], function () {

    function XhrWrapper() {
    };

    var instance = new XhrWrapper(),
        jsonRegex = /application\/json/;

    XhrWrapper.prototype.loadUrl = function(url, requestType, data) {
        return new Promise(function(resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.open(requestType, url, true);
            xhr.setRequestHeader("Content-Type", "application/json; charset=utf-8");
            xhr.onload = function(requestEvent) {
                var data;
                var responceType = requestEvent.currentTarget.getResponseHeader('Content-type');
                var status = requestEvent.currentTarget.status;
                var isJsonResult = jsonRegex.test(responceType);
                try {
                    if (isJsonResult) {
                        data = JSON.parse(requestEvent.currentTarget.responseText);
                    } else {
                        data = requestEvent.currentTarget.responseText;
                    }

                    if (xhr.status == 200 || xhr.status == 201 || xhr.status == 204) {
                        resolve({ status: xhr.status, data: data });
                    } else {
                        if (isJsonResult) {
                            reject({ status: status, data: data });
                        } else {
                            reject({
                                status: status,
                                data: {
                                    code: status,
                                    message: 'Error processing server response. Response text: ' + data
                                }
                            });
                        }
                    }

                    data = null;
                    xhr.onload = null;
                    xhr.onerror = null;
                    xhr = null;

                } catch (err) {
                    xhr.onload = null;
                    xhr.onerror = null;
                    reject({
                        status: status,
                        data: { code: status, message: 'Error processing server response.' + (err.message || err) }
                    });
                    xhr = null;
                }
            }
            xhr.onerror = function(requestEvent) {
                reject({
                    status: requestEvent.currentTarget.status,
                    data: { code: requestEvent.currentTarget.status, message: 'Server communication error.' }
                });
            }
            xhr.send(data || null);
        });
    };

    return instance;
});