#!/bin/sh

UDHCPD_CONF="/etc/udhcpd.${DEVICE_IFACE}.conf"

if [ -z "$DEVICE_IFACE" ] || [ ! -s "$UDHCPD_CONF" ] || [ "$CONNECTION_ID" != "access_point" ] ; then
	exit 0
fi

UDHCPD_BIN="/usr/sbin/udhcpd"
UDHCPD_PNAME="udhcpd"
UDHCPD_PIDFILE="/var/run/udhcpd.${DEVICE_IFACE}.pid"

if [ ! -x "$UDHCPD_BIN" ]; then
	exit 0
fi

if [ "$VERBOSITY" = "1" ]; then
	TO_NULL="/dev/stdout"
else
	TO_NULL="/dev/null"
fi

udhcpd_msg () {
	case "$1" in
		verbose)
			shift
			echo "$UDHCPD_PNAME: $@" > "$TO_NULL"
			;;
		stderr)
			shift
			echo "$UDHCPD_PNAME: $@" > /dev/stderr
			;;
		*)
			;;
	esac
}

test_udhcpd_pidfile () {
	if [ -n "$1" ] && [ -f "$2" ]; then
		if start-stop-daemon --stop --quiet --signal 0 \
			--exec "$1" --pidfile "$2"; then
			return 0
		else
			rm -f "$2"
			return 1
		fi
	else
		return 1
	fi
}

init_udhcpd () {
	UDHCPD_OPTIONS="-f $UDHCPD_CONF"
	UDHCPD_MESSAGE="$UDHCPD_BIN $UDHCPD_OPTIONS"
	
	test_udhcpd_pidfile "$UDHCPD_BIN" "$UDHCPD_PIDFILE" && return 0

	if grep "lease_file" "$UDHCPD_CONF" >/dev/null; then
		lease_file=$(grep "lease_file" "$UDHCPD_CONF" | awk '{print $2}')
		udhcpd_msg verbose "create leases file $lease_file for $UDHCPD_PIDFILE"
		touch "$lease_file"
	fi

	udhcpd_msg verbose "$UDHCPD_MESSAGE"
	start-stop-daemon --start --oknodo --quiet --background --make-pidfile --startas "$UDHCPD_BIN" \
		--pidfile "$UDHCPD_PIDFILE" -- $UDHCPD_OPTIONS > "$TO_NULL"

	if [ "$?" -ne 0 ]; then
		return "$?"
	fi

	UDHCPD_PIDFILE_WAIT=0
	until [ -s "$UDHCPD_PIDFILE" ]; do
		if [ "$UDHCPD_PIDFILE_WAIT" -ge 5 ]; then
			udhcpd_msg stderr \
				"timeout waiting for pid file creation"
			return 1
		fi

		UDHCPD_PIDFILE_WAIT=$(($UDHCPD_PIDFILE_WAIT + 1))
		sleep 1
	done
	return 0
}

kill_udhcpd () {
	UDHCPD_MESSAGE="stopping $UDHCPD_PNAME via pidfile: $UDHCPD_PIDFILE"

	test_udhcpd_pidfile "$UDHCPD_BIN" "$UDHCPD_PIDFILE" || return 0
	
	udhcpd_msg verbose "$UDHCPD_MESSAGE"
	start-stop-daemon --stop --oknodo --quiet --exec "$UDHCPD_BIN" \
		--pidfile "$UDHCPD_PIDFILE" > "$TO_NULL"

	[ -f "$UDHCPD_PIDFILE" ] && rm -f "$UDHCPD_PIDFILE"
}

udhcpd_msg verbose "udhcpd phase: $2"
case "$2" in
	up)
		init_udhcpd || exit 1
		;;
	pre-down | down)
		kill_udhcpd
		;;
	*)
		;;
esac

exit 0
