﻿// <copyright file="RangeControlController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ProgressBarController controller class for ProgressBar control
*/

define(['common/Enums', 'common/Appearence', 'base/ControlController', 'common/Error'],
function (Enums, Appearence, ControlController, Error) {
    //here we will define controller for ProgressBar

    var RangeControlController = ControlController.extend({

        currentOrientation: null,

        init: function () {
            this._super();

            this.ClassName = 'RangeControlController';
        },

        validateProperty: function (propertyName, newProperty) {
            switch (propertyName) {
                case Enums.ParameterRoles.VALUE:
                    this.validator.validateMinMax(
                        {
                            propertyName: propertyName,
                            maxValue: this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE),
                            minValue: this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE),
                            property: newProperty
                        });
                    break;
            }
        },

        modelPropertyChangedInternal: function (event) {

            this._super(event);

            var value = this.mvc.model.get(event.property);

            switch (event.property) {
                case Enums.ParameterRoles.VALUE:
                    this.onValueChanged(value);
                    break;
                case Enums.ParameterRoles.MIN_VALUE:
                    this.onMinValueChanged(value);
                    break;
                case Enums.ParameterRoles.MAX_VALUE:
                    this.onMaxValueChanged(value);
                    break;
                case Enums.ParameterRoles.ORIENTATION:
                    this.onOrientationChanged(value);
                    break;
                case Enums.ParameterRoles.FORE_COLOR:
                    this.onForeColorChanged(value);
                    break;
                case Enums.ParameterRoles.FILL_COLOR:
                    this.onFillColorChanged(value);
                    break;
            }
        },

        onValueChanged: function () {
            //    this.validateProperty(Enums.ParameterRoles.VALUE,
            //        this.mvc.model._getProperty(Enums.ParameterRoles.VALUE, false));
        },
        checkLower: function (val) {
            var value = parseFloat(val);
            if (value < this.mvc.model.getMinValue()) {
                return false;
            }

            return true;
        },

        onFillColorChanged: function (value) {
            this.mvc.view.$('.ui-progressbar-value ').css('background-color', value);
        },

        checkUpper: function (val) {
            var value = parseFloat(val);
            if (value > this.mvc.model.getMaxValue()) {
                return false;
            }

            return true;
        },
        onMinValueChanged: function (value) { //они используются у наследников RangeControl
        },

        onMaxValueChanged: function (value) {
        },

        onOrientationChanged: function (value) {

        },

        onForeColorChanged: function (value) {

        },
    });

    return RangeControlController;
});
