﻿// <copyright file="ActivexController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

define(['common/Enums', 'base/ControlController', 'common/Utilites', 'common/Error'],
function (Enums, ControlController, Utilities, Error) {
    var ActivexController = ControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'ActivexController';
            this.initialized = false;
            this.modelChanged[Enums.ParameterRoles.CLASSID] = this.onClassIdChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.CODEBASE] = this.onCodebaseChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.PARAMETERS] = this.onParametersChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.CAB] = this.onCabChanged.bind(this);
        },

        onAddedToDOM: function () {
            this.initialized = true;
            this.setObjectParameters();
            if (Utilities.isIE())
                if (this.mvc.model.get(Enums.ParameterRoles.CLASSID) && this.mvc.model.get(Enums.ParameterRoles.CODEBASE))
                    this.mvc.view.$()[0].connect();
                else
                    Error.warn(String.format("Параметры для {0} {1} не были заданы", this.mvc.model.get(Enums.ParameterRoles.ROLE), this.mvc.model.get(Enums.ParameterRoles.ID)));
            else
                Error.warn(String.format("{0} {1} не будет работать в браузере, отличном от Internet Explorer", this.mvc.model.get(Enums.ParameterRoles.ROLE), this.mvc.model.get(Enums.ParameterRoles.ID)));
        },

        modelPropertyChangedInternal: function (event) {
            this._super(event);
        },
        onClassIdChanged: function () {
            this.mvc.view.$().attr('classid', this.mvc.model.get(Enums.ParameterRoles.CLASSID));
        },
        onCodebaseChanged: function () {
            this.mvc.view.$().attr('codebase', this.mvc.model.get(Enums.ParameterRoles.CODEBASE));
        },
        onCabChanged: function () { //ресурс на .cab файл

        },
        onParametersChanged: function () {
            if (this.initialized) {
                this.setObjectParameters();
            }
        },
        setParam: function(name, value){
            var param = document.createElement('param');
            param.name = name;
            param.value = value;
            //    this.mvc.view.$()[0].appendChild(param);
            this.mvc.view.$()[0][param.name] = param.value;
        },
        setObjectParameters: function(){
            this.parameters = this.parseParameters(this.mvc.model.get(Enums.ParameterRoles.PARAMETERS));
            for (var key in this.parameters) {
                this.setParam(key, this.parameters[key]);
            }
        },
        parseParameters: function (parameters) {
            var vars = parameters.split("#");
            var result = {};
            for (var i = 0; i < vars.length; i++) {
                var pair = vars[i].split("=");
                result[pair[0]] = pair[1];
            }
            return result;
        }
    });

    return ActivexController;
});