﻿// <copyright file="SliderController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class SliderController controller class for Slider control
*/

define(['common/Enums', 'common/Appearence', 'base/ControlController'],
    function (Enums, Appearence, ControlController) {
        //here we will define controller for Slider

        return ControlController.extend({

            init: function () {
                this._super();
                this.ClassName = 'SliderController';
                this.initialized = false;

                //this.modelChanged[Enums.ParameterRoles.SLIDER_SIZE] = this.onForeWidthChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.MIN_VALUE] = this.onMinMaxValueChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.MAX_VALUE] = this.onMinMaxValueChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.VALUE] = this.onValueChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FORE_COLOR] = this.onForeColorChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FILL_COLOR] = this.onFillColorChanged.bind(this);
                //this.modelChanged["Orientation"] = this.onOrientationChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.OVERFLOW_SIZE] = this.onOverflowChanged.bind(this);
                //this.modelChanged[Enums.ParameterRoles.IS_OVERFLOW] = this.onOverflowChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FORE_BORDER_RADIUS] = this.onForeBorderRadiusChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FORE_BORDER_WIDTH] = this.onBorderPropertiesChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FORE_BORDER_COLOR] = this.onBorderPropertiesChanged.bind(this);
            },

            onModelInit: function (event) {
                this._super();
                var self = this;
                this.mvc.view.$().slider({
                    orientation: sliderOrientation(this.mvc.model.getOrientation()),
                    min: this.mvc.model.getMinValue(),
                    max: this.mvc.model.getMaxValue(),
                    value: this.mvc.model.getValue(),
                    angleRotation: this.mvc.model.get(Enums.ParameterRoles.ANGLE),
                    disabled: !this.mvc.model.getIsEnabled(),
                    animate: 'fast',
                    range: this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR) ? 'min' : false,
                    change: function (event, ui) { self.onChange(event, ui); }
                });
                this.mvc.view.$().slider().css('overflow', 'visible');
                this.applyForeColor(this.mvc.model.get(Enums.ParameterRoles.FORE_COLOR));
                this.initialized = true;
            },

            attachEvents: function (elem) {
                this._super(elem);
                var self = this;
                elem.mousewheel(function (e, delta) {
                    self.onWheel(e, delta);
                }.bind(this));
            },

            onAddedToDOM: function (event) {
                this._super(event);
                if (this.initialized === true) {
                    var skin = this.mvc.model.get(Enums.ParameterRoles.SKIN);
                    if (skin) {
                        this.applyForeSkin(skin);
                    }
                    this.drawSlider();
                    this.onFillColorChanged();
                    this.applyShadow();
                }
            },

            drawSlider: function () {
                var overflow = this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW);
                if (overflow) {
                    if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                        this.appendHorizontalFooter();
                    } else {
                        this.appendVerticalFooter();
                    }
                } else {
                    var overflowSize = this.mvc.model.get(Enums.ParameterRoles.OVERFLOW_SIZE);
                    var size = this.mvc.model.getSliderRelativeSize();
                    var anotherSize = 2 * overflowSize + 100;
                    var sliderRadius = this.mvc.model.get(Enums.ParameterRoles.CORNER_RADIUS);
                    if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                        this.mvc.view.$('.ui-slider-handle').css({
                            'box-sizing': 'content-box',
                            'top': 0,
                            'height': anotherSize + '%',
                            'width': size + '%',
                            'margin-left': -size / 2 + '%',
                        });
                        this.applyForeBorderRadius();
                        this.applyBorderProperties();
                        this.centrateHorizontalFore();
                        this.applySliderBorderRadius();

                    } else {
                        this.mvc.view.$('.ui-slider-handle').css({
                            'box-sizing': 'content-box',
                            'left': 0,
                            'height': size + '%',
                            'width': anotherSize + '%',
                        });
                        var margin = (-50 * (this.mvc.view.$('.ui-slider-handle').height() / this.mvc.view.$('.ui-slider-handle').width()));
                        this.mvc.view.$('.ui-slider-handle').css({
                            'margin-bottom': margin + '%',
                        });
                        this.applyForeBorderRadius();
                        this.applyBorderProperties();
                        this.centrateVerticalFore();
                        this.applySliderBorderRadius();
                    }
                }
            },

            onWidthChanged: function (event) {
                this._super();
                var overflow = this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW);
                var marginPercent = 100 * (this.mvc.view.$('.ui-slider-handle').height() / this.mvc.view.$('.ui-slider-handle').width());
                if (this.mvc.model.getOrientation() === Enums.OrientationType.Vertical) {
                    if (overflow) {
                        this.mvc.view.$('.ui-slider-handle').css({
                            'margin-bottom': -marginPercent + '%'
                        });
                    } else {
                        this.mvc.view.$('.ui-slider-handle').css({
                            'margin-bottom': -marginPercent / 2 + '%'
                        });
                    }
                } else {
                    if (overflow) {
                        if (this.haveAppended()) {
                            margin = this.mvc.view.$('.ui-slider-handle').css('width').replace('px', '');
                            var width = this.mvc.view.$().slider().css('width').replace('px', '');
                            var percentWidth = this.mvc.view.$()[0].style.width.replace('%', '');
                            var newWidth = percentWidth * (1 - margin / width);
                            this.mvc.view.$().slider().css('width', newWidth + '%');
                        }
                    }
                }
            },

            onHeightChanged: function () {
                this._super();
                var overflow = this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW);
                var margin = this.mvc.view.$('.ui-slider-handle').css('height').replace('px', '');
                if (this.mvc.model.getOrientation() === Enums.OrientationType.Vertical) {
                    if (overflow) {
                        if (this.haveAppended()) {
                            var newHeight = 0;
                            var height = this.mvc.view.$().slider().css('height').replace('px', '');
                            var percentHeight = this.mvc.view.$()[0].style.height.replace('%', '');
                            if (parseInt(height, 10)) {
                                newHeight = percentHeight * (1 - margin / height);
                            }
                            this.mvc.view.$().slider().css('height', newHeight + '%');
                        }
                    }
                }
                this.onWidthChanged();
            },

            haveAppended: function () {
                return !!this.mvc.view.$('#appended')[0];
            },

            onForeColorChanged: function () {
                var value = this.mvc.model.get(Enums.ParameterRoles.FORE_COLOR);
                this.applyForeColor(value);
            },

            onValueChanged: function () {
                this.settingValue = true;
                this.mvc.view.$().slider("option", "value", this.mvc.model.get(Enums.ParameterRoles.VALUE));
                this.settingValue = false;
            },

            onAngleChanged: function (value) {
                this._super(value);
                this.mvc.view.$().slider("option", "angleRotation",
                    this.mvc.model.get(Enums.ParameterRoles.ANGLE));
            },

            onMinMaxValueChanged: function () {
                if (this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE) < this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE)) {
                    this.mvc.view.$().slider("option", "min", this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE));
                    this.mvc.view.$().slider("option", "max", this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE));
                } else {
                    console.warn(String.format("У ползунка {0} нижняя граница больше правой: {1}-{2}", this.mvc.model.getId(), this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE), this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE)))
                }
            },

            onIsEnabledChanged: function (value) {
                this._super(value);

                if (value) {
                    this.mvc.view.$().slider('enable');
                }
                else {
                    this.mvc.view.$().slider('disable');
                }
            },

            onFillColorChanged: function () {
                if (this.mvc.model.getOrientation() === Enums.OrientationType.Vertical) {
                    var fillColor = this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR);
                    if (fillColor == 'transparent')
                        fillColor = this.mvc.model.get(Enums.ParameterRoles.BACKGROUND_COLOR);
                    if (Appearence.color.isColor(fillColor) || Appearence.color.isARGB(fillColor))
                        this.mvc.view.$('#appended').css('background', Appearence.color.toCssColor(fillColor));
                }
                this.applyFillColor();
            },

            onBackgroundColorChanged: function (value) {
                this._super(value);
                this.onFillColorChanged();
            },

            applyShadow: function () {
                this._super();
                if (this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW)) {

                    var shadow = {
                        size: this.mvc.model.get(Enums.ParameterRoles.SHADOW_SIZE),
                        color: this.getMixedShadowColor(
                            this.mvc.model.getShadowColor(),
                            this.mvc.model.getBackgroundColor())
                    };
                    Appearence.shadow.applyBoxShadow(this.mvc.view.$('#appended'), shadow);
                    var bgColor = this.mvc.model.get(Enums.ParameterRoles.BACKGROUND_COLOR);
                    Appearence.background.apply(this.mvc.view.$('#appended'), bgColor);
                    this.onFillColorChanged();
                }
            },

            onCornerRadiusChanged: function () {
                this._super();
                if (this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW)) {
                    if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                        this.applyHorizontalBorderRadius();
                    }
                    else {
                        this.applyVerticalBorderRadius();
                    }
                }
                else {
                    this.applySliderBorderRadius();
                }
            },

            onOverflowChanged: function (event) {
                var overflowedHeight = 2 * event + 100;
                this.mvc.view.$('.ui-slider-handle').css({ //устанавливаем необходимые свойства в ползунок
                    'height': overflowedHeight + '%',
                });

                if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                    this.centrateHorizontalFore();
                }
                else {
                    this.centrateVerticalFore();
                }
            },

            onForeBorderRadiusChanged: function (event) {
                this.mvc.view.$('.ui-slider-handle').css('border-radius', event + 'px ' + event + 'px ' + event + 'px ' + event + 'px ');
            },

            onBorderPropertiesChanged: function (event) {
                var foreBorderCss = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_WIDTH) +
                    'px solid ' + this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_COLOR);
                this.mvc.view.$('.ui-slider-handle').css('border', foreBorderCss);
                if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                    this.centrateHorizontalFore();
                }
                else {
                    this.centrateVerticalFore();
                }
            },

            //
            // Events
            //      
            onWheel: function (e, delta) {
                var value = this.mvc.model.getValue() + delta;
                if ((value > this.mvc.model.getMaxValue()) || value < this.mvc.model.getMinValue()) {
                    return;
                }
                else {
                    this.mvc.model.setValue(value);
                }
            },

            onChange: function (event, ui) {

                if (this.settingValue) {
                    return;
                }
                this.mvc.model.setValue(ui.value);
            },

            ///
            ///appearence settings
            ///
            appendHorizontalFooter: function () {
                this.prepareToAppendHorizontalFooter();
                this.createHorizontalFooter();
                this.applyHorizontalBorderRadius();
                this.applyForeBorderRadius();
                this.applyBorderProperties();
                this.centrateHorizontalFore();
            },

            appendVerticalFooter: function () {
                this.prepareToAppendVerticalFooter();
                this.createVerticalFooter();
                this.applyVerticalBorderRadius();
                this.applyForeBorderRadius();
                this.applyBorderProperties();
                this.centrateVerticalFore();
            },

            createHorizontalFooter: function () {
                var margin = this.mvc.model.getSliderRelativeSize();
                var bgColor = this.mvc.view.$().slider().css('background-color');
                var footColor = this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR);
                if (footColor == 'transparent') footColor = bgColor;
                var footer = {
                    'height': '100%',
                    'width': margin + '%',
                    'margin-left': '100%',
                    'border': 'inherit',
                    'border-left': 'none',
                    'background': footColor
                };
                this.mvc.view.$().slider().append("<div id ='appended'></div>");
                this.mvc.view.$('#appended').css(footer);
                this.mvc.view.$('#appended').css('position', "relative");
                this.mvc.view.$().slider().css('box-sizing', 'content-box');
                var border = this.mvc.view.$().slider().css('border-top-width').replace('px', ''); //размер рамки в пикселях
                var sliderWidth = this.mvc.view.$().slider().css('width').replace('px', '');
                var relBord = border / sliderWidth * 25;
                this.mvc.view.$('#appended').css('margin-top', -border + "px");
                this.mvc.view.$('#appended').css('left', -relBord + "%");
            },

            createVerticalFooter: function () {
                var margin = this.mvc.model.getSliderRelativeSize();
                var bgColor = this.mvc.view.$().slider().css('background-color');
                var footColor = this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR);
                if (footColor == 'transparent') footColor = bgColor;
                var footer = {
                    'width': '100%',
                    'height': margin + '%',
                    'border': 'inherit',
                    'border-top': 'none',
                    'background': footColor
                };
                this.mvc.view.$().slider().append("<div id ='appended'></div>");
                this.mvc.view.$('#appended').css(footer);
                this.mvc.view.$('#appended').css('top', 100 + "%");
                this.mvc.view.$('#appended').css('position', "relative");
                this.mvc.view.$().slider().css('box-sizing', 'content-box');

                var foreHeight = this.mvc.view.$('.ui-slider-handle').css('height').replace('px', '');
                var sliderWidthPx = this.mvc.view.$().slider().css('width').replace('px', ''); //размер слайдера в пикселях
                var foreBorderWidth = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_WIDTH);
                var margleHand = 100 * (foreBorderWidth + 1 * foreHeight) / sliderWidthPx;
                this.mvc.view.$('.ui-slider-handle').css('margin-bottom', -margleHand + '%');

                var sliderBorder = this.mvc.view.$().slider().css('border-top-width').replace('px', ''); //размер рамки в пикселях
                this.mvc.view.$('#appended').css('margin-left', -sliderBorder + "px");
            },

            prepareToAppendHorizontalFooter: function () {
                var margin = this.mvc.model.getSliderRelativeSize();//отступ равен размеру ползунка (это значение равно проценту ползунка от слайдера)
                var decrease = 100 / (100 + margin);  //коэффициент уменьшения дива
                var windWidth = this.mvc.view.$()[0].style.width.replace('%', ''); //процент слайдера от окна
                var leftBeforeDecrease = this.mvc.view.$()[0].style.left.replace('%', '');//положение до уменьшения - его нужно сдвинуть на change
                var newWidth = windWidth * decrease;//новая высота в процентах  
                var overflowSize = this.mvc.model.get(Enums.ParameterRoles.OVERFLOW_SIZE);
                var overflowedHeight = 2 * overflowSize + 100;
                var borderForePx = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_WIDTH);
                var sliderWidthPx = this.mvc.model.get(Enums.ParameterRoles.WIDTH);
                var borderRel = borderForePx / sliderWidthPx * 100;
                this.mvc.view.$('.ui-slider-handle').css({ //устанавливаем необходимые свойства в ползунок
                    'width': margin + '%',
                    'margin-left': -borderRel + '%',
                    'height': overflowedHeight + '%',
                    'top': 0,
                });
                this.mvc.view.$().slider().css('width', newWidth + "%");

            },

            prepareToAppendVerticalFooter: function () {
                var margin = this.mvc.model.getSliderRelativeSize();//отступ равен размеру ползунка (это значение равно проценту ползунка от слайдера)
                var overflowSize = this.mvc.model.get(Enums.ParameterRoles.OVERFLOW_SIZE);
                var overflowedWidth = 2 * overflowSize + 100;
                var foreHeight = this.mvc.view.$('.ui-slider-handle').css('height').replace('px', '');
                var sliderWidthPx = this.mvc.view.$().slider().css('width').replace('px', ''); //размер слайдера в пикселях
                var borderWidth = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_WIDTH);
                var margleHand = 100 * (borderWidth + 1 * foreHeight) / sliderWidthPx;
                this.mvc.view.$('.ui-slider-handle').css({ //устанавливаем необходимые свойства в ползунок
                    'height': margin + '%',
                    'margin-bottom': -margleHand + '%',
                    'width': overflowedWidth + '%',
                    'left': 0,
                    'margin-left': -1 + 'px'
                });
                var decrease = 100 / (100 + margin);  //коэффициент уменьшения дива
                var windHeight = this.mvc.view.$()[0].style.height.replace('%', ''); //процент слайдера от окна
                var newHeight = windHeight * decrease;//новая высота в процентах  
                this.mvc.view.$().slider().css('height', newHeight + "%");
            },

            applySliderBorderRadius: function () {
                var sliderRadius = this.mvc.model.get(Enums.ParameterRoles.CORNER_RADIUS);
                this.mvc.view.$().slider().css('border-radius', sliderRadius + 'px ' + sliderRadius + 'px ' + sliderRadius + 'px ' + sliderRadius + 'px');
                this.mvc.view.$('.ui-slider-range').css('border-radius', sliderRadius + 'px ' + sliderRadius + 'px ' + sliderRadius + 'px ' + sliderRadius + 'px');
            },

            applyHorizontalBorderRadius: function () {
                var sliderRadius = this.mvc.model.get(Enums.ParameterRoles.CORNER_RADIUS);
                var foreSize = this.mvc.model.get(Enums.ParameterRoles.SLIDER_SIZE);
                if (sliderRadius >= 1.5 * foreSize) sliderRadius = 1.5 * foreSize;
                this.mvc.view.$().slider().css('border-radius', sliderRadius + 'px ' + '0px 0px ' + sliderRadius + 'px');
                this.mvc.view.$('.ui-slider-range').css('border-radius', sliderRadius + 'px ' + '0px 0px ' + sliderRadius + 'px');
                this.mvc.view.$('#appended').css('border-radius', '0 ' + sliderRadius + 'px ' + sliderRadius + 'px ' + '0px');
            },

            applyVerticalBorderRadius: function () {
                var sliderRadius = this.mvc.model.get(Enums.ParameterRoles.CORNER_RADIUS);
                var foreSize = this.mvc.model.get(Enums.ParameterRoles.SLIDER_SIZE);
                if (sliderRadius >= 1.5 * foreSize) sliderRadius = 1.5 * foreSize;
                this.mvc.view.$().slider().css('border-radius', sliderRadius + 'px ' + sliderRadius + 'px ' + '0 0');
                this.mvc.view.$('.ui-slider-range').css('border-radius', sliderRadius + 'px ' + sliderRadius + 'px ' + '0 0');
                this.mvc.view.$('#appended').css('border-radius', '0 0 ' + sliderRadius + 'px ' + sliderRadius + 'px');
            },

            applyForeBorderRadius: function () {
                var foreRadius = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_RADIUS);
                this.mvc.view.$('.ui-slider-handle').css('border-radius', foreRadius + 'px ' + foreRadius + 'px ' + foreRadius + 'px ' + foreRadius + 'px ');
            },

            applyBorderProperties: function () {
                var borderStyle = Appearence.border.getBorderStyle(this.mvc.model.get(Enums.ParameterRoles.BORDER_STYLE));
                var foreBorderCss = this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_WIDTH) +
                    'px solid ' +
                    this.mvc.model.get(Enums.ParameterRoles.FORE_BORDER_COLOR)
                var sliderBorderCss = borderStyle + " " + this.mvc.model.get(Enums.ParameterRoles.BORDER_THIKNESS) +
                    'px ' + this.mvc.model.get(Enums.ParameterRoles.BORDER_COLOR);
                this.mvc.view.$().slider().css('box-sizing', 'content-box');
                this.mvc.view.$('.ui-slider-handle').css('border', foreBorderCss);
                this.mvc.view.$().slider().css('border', sliderBorderCss);
                var overflow = this.mvc.model.get(Enums.ParameterRoles.IS_OVERFLOW);
                if (overflow) {
                    if (this.mvc.model.getOrientation() === Enums.OrientationType.Horizontal) {
                        this.mvc.view.$().slider().css('border-right', 'none');
                        this.mvc.view.$('#appended').css('border-right', sliderBorderCss);
                    }
                    else {
                        this.mvc.view.$().slider().css('border-bottom', 'none');
                        this.mvc.view.$('#appended').css('border-bottom', sliderBorderCss);
                    }
                }
            },

            centrateHorizontalFore: function () {
                var overflowSize = this.mvc.model.get(Enums.ParameterRoles.OVERFLOW_SIZE);
                var sliderWidthPx = this.mvc.view.$().slider().css('width').replace('px', '');
                var sliderHeightPx = this.mvc.view.$().slider().css('height').replace('px', '');
                var borderForePx = this.mvc.view.$('.ui-slider-handle').css('border-top-width').replace('px', '');
                var bordAdd = borderForePx / sliderWidthPx * 100;
                var horOver = (sliderHeightPx / sliderWidthPx) * overflowSize;
                var totalMargin = horOver + 1 * bordAdd;
                this.mvc.view.$('.ui-slider-handle').css({
                    'margin-top': -totalMargin + '%'
                });
            },

            centrateVerticalFore: function () {
                var overflowSize = this.mvc.model.get(Enums.ParameterRoles.OVERFLOW_SIZE);
                var sliderWidthPx = this.mvc.view.$().slider().css('width').replace('px', '');
                var borderForePx = this.mvc.view.$('.ui-slider-handle').css('border-top-width').replace('px', '');
                var bordAdd = borderForePx / sliderWidthPx * 100;
                var foreMargin = overflowSize + 1 * bordAdd;
                this.mvc.view.$('.ui-slider-handle').css({
                    'margin-left': -foreMargin + '%'
                });
            },

            applyForeSkin: function (value) {
                var customSvg = this.mvc.model.resourceManager.resolve(value);
                var cssOptions = {
                    border: 'none',
                    background: 'url(' + customSvg + ')',
                    'background-color': 'transparent',
                    'background-repeat': 'no-repeat',
                    'background-position': '50% 50%',
                    'background-size': '100% 100%',
                };
                this.mvc.view.$('.ui-state-default, .ui-state-default .ui-state-focus')
                    .css(cssOptions);
            },

            applySkin: function () {
                //empty method for inheritance
            },

            applyForeColor: function (value) {
                if (Appearence.color.isColor(value) || Appearence.color.isARGB(value))
                    this.mvc.view.$('.ui-slider-handle')
                        .css('background', Appearence.color.toCssColor(value));
            },

            applyFillColor: function () {
                var fillColor = this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR);
                if (Appearence.color.isColor(fillColor) || Appearence.color.isARGB(fillColor))
                    this.mvc.view.$('.ui-widget-header').css('background', Appearence.color.toCssColor(fillColor));
            },

        });

        /*
        * @method sliderOrientation returns slider orientation by enum
        */
        function sliderOrientation(orientation) {
            return orientation === Enums.OrientationType.Horizontal ? 'horizontal' : 'vertical';
        }
    });
