﻿// <copyright file="TabControlItemController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class TabControlItemController controller class for TabControlItem control
*/
define(['common/Enums', 'base/CanvasContainerController'],
function (Enums, CanvasContainerController) {

    var TabControlItemController = CanvasContainerController.extend({

        init: function () {
            this._super();

            this.ClassName = 'TabControlItemController';
        },

        onAddedToDOM: function () {
            this._super();

            this.mvc.view.$().attr('id', this.clientId());
        },

        setTabId: function (value) {
            this.mvc.view.$().attr('id', value);
        },

        renderPosition: function () {
            //do nothing - just override parent's behaviour
        },

        modelPropertyChangedInternal: function (event) {

            this._super(event);

            var value = this.mvc.model.get(event.property);

            switch (event.property) {
                case Enums.ParameterRoles.TEXT:
                    this.onTextChanged(value);
                    break;
            }
        },

        onTextChanged: function (value) {

            //do nothing because we will have problems 
        },

        applyWidth: function () {
            //do nothing - only override parent's behaviour
        },

        applyHeight: function () {
            //do nothing - only override parent's behaviour
        }
    });

    return TabControlItemController;
});
