﻿define(['core/global/GlobalEvents', 'common/Enums', 'common/Error'],
    function (GlobalEvents, Enums, Error) {

    var baseUrl = 'resources',
        defaultLocale = 'en',
        locale,
        messages;

    function Localization() {
    }

    Localization.prototype.setLocale = function (newLocale) {
        locale = newLocale;
        return _loadResourceFile();
    }

    Localization.prototype.init = function () {
        return _loadResourceFile();
    }

    function _loadResourceFile() {
        return new Promise(function (resolve, reject) {
            if (locale === undefined) {
                Error.warn(String.format('Locale is not defined. Switching to default locale({0}).',
                    defaultLocale));
            }

            locale = locale || defaultLocale;
            var fileName = [baseUrl, locale].join('/');
            curl([fileName], function(resource) {
                messages = resource;
                resolve(messages);
                GlobalEvents.fire({ type: Enums.GlobalEventsTypes.languageChanged, lang: locale });
            }, function() {
                var msg = String.format('File {0} was not found.', fileName);
                Error.onerror(msg);
                reject(msg);
            });
        });
    }

    Localization.prototype.get = function (id) {
        var result = messages;
        id = id.split('.');
        for (var i = 0; i < id.length; ++i) {
            if (result[id[i]] !== undefined) {
                result = result[id[i]];
            } else {
                Error.warn(String.format('Property {0} was not found in locale {1}.',
                    id.slice(0, i).join('.')));
                return '';
            }
        }

        return result;
    }

    return new Localization();
});