// <copyright file="ActionAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['helpers/contextResolver', 'core/adapters/BaseAdapter'], function (contextResolver, BaseAdapter) {

    var ActionAdapter = BaseAdapter.extend({
        init: function (settings, type) {
            this._super(settings, type);
            var position = this.settings.path.lastIndexOf('/');
            this.actionId = this.settings.path.substr(position + 1);
            this.elementPath = this.settings.path.substring(0, position);
            this.elementPath = this.elementPath == "" ? "/" : this.elementPath;

            this.adapterType = "ActionAdapter";
        },

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.elementPath, ctx).controller.actions[this.actionId];
        }
    });

	return ActionAdapter;
});